/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteMultipartUploadResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, CompleteMultipartUploadResponse> {
    private final String location;
    private final String checksum;
    private final String archiveId;

    private CompleteMultipartUploadResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.checksum = builder.checksum;
        this.archiveId = builder.archiveId;
    }

    public String location() {
        return this.location;
    }

    public String checksum() {
        return this.checksum;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadResponse)) {
            return false;
        }
        CompleteMultipartUploadResponse other = (CompleteMultipartUploadResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.archiveId(), other.archiveId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.archiveId() != null) {
            sb.append("ArchiveId: ").append(this.archiveId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "archiveId": {
                return Optional.of(clazz.cast(this.archiveId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String checksum;
        private String archiveId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadResponse model) {
            this.location(model.location);
            this.checksum(model.checksum);
            this.archiveId(model.archiveId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public CompleteMultipartUploadResponse build() {
            return new CompleteMultipartUploadResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, CompleteMultipartUploadResponse> {
        public Builder location(String var1);

        public Builder checksum(String var1);

        public Builder archiveId(String var1);
    }
}

