/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.ProvisionedCapacityDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedCapacityDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisionedCapacityDescription> {
    private final String capacityId;
    private final String startDate;
    private final String expirationDate;

    private ProvisionedCapacityDescription(BuilderImpl builder) {
        this.capacityId = builder.capacityId;
        this.startDate = builder.startDate;
        this.expirationDate = builder.expirationDate;
    }

    public String capacityId() {
        return this.capacityId;
    }

    public String startDate() {
        return this.startDate;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.capacityId() == null ? 0 : this.capacityId().hashCode());
        hashCode = 31 * hashCode + (this.startDate() == null ? 0 : this.startDate().hashCode());
        hashCode = 31 * hashCode + (this.expirationDate() == null ? 0 : this.expirationDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacityDescription)) {
            return false;
        }
        ProvisionedCapacityDescription other = (ProvisionedCapacityDescription)obj;
        if (other.capacityId() == null ^ this.capacityId() == null) {
            return false;
        }
        if (other.capacityId() != null && !other.capacityId().equals(this.capacityId())) {
            return false;
        }
        if (other.startDate() == null ^ this.startDate() == null) {
            return false;
        }
        if (other.startDate() != null && !other.startDate().equals(this.startDate())) {
            return false;
        }
        if (other.expirationDate() == null ^ this.expirationDate() == null) {
            return false;
        }
        return other.expirationDate() == null || other.expirationDate().equals(this.expirationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.capacityId() != null) {
            sb.append("CapacityId: ").append(this.capacityId()).append(",");
        }
        if (this.startDate() != null) {
            sb.append("StartDate: ").append(this.startDate()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityId": {
                return Optional.of(clazz.cast(this.capacityId()));
            }
            case "StartDate": {
                return Optional.of(clazz.cast(this.startDate()));
            }
            case "ExpirationDate": {
                return Optional.of(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedCapacityDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityId;
        private String startDate;
        private String expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacityDescription model) {
            this.capacityId(model.capacityId);
            this.startDate(model.startDate);
            this.expirationDate(model.expirationDate);
        }

        public final String getCapacityId() {
            return this.capacityId;
        }

        @Override
        public final Builder capacityId(String capacityId) {
            this.capacityId = capacityId;
            return this;
        }

        public final void setCapacityId(String capacityId) {
            this.capacityId = capacityId;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        public ProvisionedCapacityDescription build() {
            return new ProvisionedCapacityDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedCapacityDescription> {
        public Builder capacityId(String var1);

        public Builder startDate(String var1);

        public Builder expirationDate(String var1);
    }
}

