/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.VaultListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVaultsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListVaultsResponse> {
    private final List<DescribeVaultOutput> vaultList;
    private final String marker;

    private ListVaultsResponse(BuilderImpl builder) {
        this.vaultList = builder.vaultList;
        this.marker = builder.marker;
    }

    public List<DescribeVaultOutput> vaultList() {
        return this.vaultList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vaultList() == null ? 0 : this.vaultList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResponse)) {
            return false;
        }
        ListVaultsResponse other = (ListVaultsResponse)((Object)obj);
        if (other.vaultList() == null ^ this.vaultList() == null) {
            return false;
        }
        if (other.vaultList() != null && !other.vaultList().equals(this.vaultList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vaultList() != null) {
            sb.append("VaultList: ").append(this.vaultList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultList": {
                return Optional.of(clazz.cast(this.vaultList()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DescribeVaultOutput> vaultList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsResponse model) {
            this.vaultList(model.vaultList);
            this.marker(model.marker);
        }

        public final Collection<DescribeVaultOutput.Builder> getVaultList() {
            return this.vaultList != null ? (Collection)this.vaultList.stream().map(DescribeVaultOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(DescribeVaultOutput ... vaultList) {
            this.vaultList(Arrays.asList(vaultList));
            return this;
        }

        public final void setVaultList(Collection<DescribeVaultOutput.BuilderImpl> vaultList) {
            this.vaultList = VaultListCopier.copyFromBuilder(vaultList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListVaultsResponse build() {
            return new ListVaultsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVaultsResponse> {
        public Builder vaultList(Collection<DescribeVaultOutput> var1);

        public Builder vaultList(DescribeVaultOutput ... var1);

        public Builder marker(String var1);
    }
}

