/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.glacier.model.UploadListElement;
import software.amazon.awssdk.services.glacier.model.UploadsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListMultipartUploadsResponse> {
    private final List<UploadListElement> uploadsList;
    private final String marker;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        this.uploadsList = builder.uploadsList;
        this.marker = builder.marker;
    }

    public List<UploadListElement> uploadsList() {
        return this.uploadsList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uploadsList() == null ? 0 : this.uploadsList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse)((Object)obj);
        if (other.uploadsList() == null ^ this.uploadsList() == null) {
            return false;
        }
        if (other.uploadsList() != null && !other.uploadsList().equals(this.uploadsList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.uploadsList() != null) {
            sb.append("UploadsList: ").append(this.uploadsList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadsList": {
                return Optional.of(clazz.cast(this.uploadsList()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<UploadListElement> uploadsList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            this.uploadsList(model.uploadsList);
            this.marker(model.marker);
        }

        public final Collection<UploadListElement.Builder> getUploadsList() {
            return this.uploadsList != null ? (Collection)this.uploadsList.stream().map(UploadListElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploadsList(Collection<UploadListElement> uploadsList) {
            this.uploadsList = UploadsListCopier.copy(uploadsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(UploadListElement ... uploadsList) {
            this.uploadsList(Arrays.asList(uploadsList));
            return this;
        }

        public final void setUploadsList(Collection<UploadListElement.BuilderImpl> uploadsList) {
            this.uploadsList = UploadsListCopier.copyFromBuilder(uploadsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        public Builder uploadsList(Collection<UploadListElement> var1);

        public Builder uploadsList(UploadListElement ... var1);

        public Builder marker(String var1);
    }
}

