/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.InventoryRetrievalJobInputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryRetrievalJobInput
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryRetrievalJobInput> {
    private final String startDate;
    private final String endDate;
    private final String limit;
    private final String marker;

    private InventoryRetrievalJobInput(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    public String startDate() {
        return this.startDate;
    }

    public String endDate() {
        return this.endDate;
    }

    public String limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.startDate() == null ? 0 : this.startDate().hashCode());
        hashCode = 31 * hashCode + (this.endDate() == null ? 0 : this.endDate().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryRetrievalJobInput)) {
            return false;
        }
        InventoryRetrievalJobInput other = (InventoryRetrievalJobInput)obj;
        if (other.startDate() == null ^ this.startDate() == null) {
            return false;
        }
        if (other.startDate() != null && !other.startDate().equals(this.startDate())) {
            return false;
        }
        if (other.endDate() == null ^ this.endDate() == null) {
            return false;
        }
        if (other.endDate() != null && !other.endDate().equals(this.endDate())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.startDate() != null) {
            sb.append("StartDate: ").append(this.startDate()).append(",");
        }
        if (this.endDate() != null) {
            sb.append("EndDate: ").append(this.endDate()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartDate": {
                return Optional.of(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.of(clazz.cast(this.endDate()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryRetrievalJobInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String startDate;
        private String endDate;
        private String limit;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryRetrievalJobInput model) {
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.limit(model.limit);
            this.marker(model.marker);
        }

        public final String getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public InventoryRetrievalJobInput build() {
            return new InventoryRetrievalJobInput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryRetrievalJobInput> {
        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder limit(String var1);

        public Builder marker(String var1);
    }
}

