/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.glacier.model.JobParameters;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, InitiateJobRequest> {
    private final String accountId;
    private final String vaultName;
    private final JobParameters jobParameters;

    private InitiateJobRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.jobParameters = builder.jobParameters;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public JobParameters jobParameters() {
        return this.jobParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.jobParameters() == null ? 0 : this.jobParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobRequest)) {
            return false;
        }
        InitiateJobRequest other = (InitiateJobRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.jobParameters() == null ^ this.jobParameters() == null) {
            return false;
        }
        return other.jobParameters() == null || other.jobParameters().equals(this.jobParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.jobParameters() != null) {
            sb.append("JobParameters: ").append(this.jobParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "jobParameters": {
                return Optional.of(clazz.cast(this.jobParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private JobParameters jobParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateJobRequest model) {
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.jobParameters(model.jobParameters);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final JobParameters.Builder getJobParameters() {
            return this.jobParameters != null ? this.jobParameters.toBuilder() : null;
        }

        @Override
        public final Builder jobParameters(JobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final void setJobParameters(JobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        public InitiateJobRequest build() {
            return new InitiateJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InitiateJobRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder jobParameters(JobParameters var1);
    }
}

