/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVaultResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVaultResponse> {
    private final String vaultARN;
    private final String vaultName;
    private final String creationDate;
    private final String lastInventoryDate;
    private final Long numberOfArchives;
    private final Long sizeInBytes;

    private DescribeVaultResponse(BuilderImpl builder) {
        this.vaultARN = builder.vaultARN;
        this.vaultName = builder.vaultName;
        this.creationDate = builder.creationDate;
        this.lastInventoryDate = builder.lastInventoryDate;
        this.numberOfArchives = builder.numberOfArchives;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public String lastInventoryDate() {
        return this.lastInventoryDate;
    }

    public Long numberOfArchives() {
        return this.numberOfArchives;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vaultARN() == null ? 0 : this.vaultARN().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.lastInventoryDate() == null ? 0 : this.lastInventoryDate().hashCode());
        hashCode = 31 * hashCode + (this.numberOfArchives() == null ? 0 : this.numberOfArchives().hashCode());
        hashCode = 31 * hashCode + (this.sizeInBytes() == null ? 0 : this.sizeInBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVaultResponse)) {
            return false;
        }
        DescribeVaultResponse other = (DescribeVaultResponse)((Object)obj);
        if (other.vaultARN() == null ^ this.vaultARN() == null) {
            return false;
        }
        if (other.vaultARN() != null && !other.vaultARN().equals(this.vaultARN())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastInventoryDate() == null ^ this.lastInventoryDate() == null) {
            return false;
        }
        if (other.lastInventoryDate() != null && !other.lastInventoryDate().equals(this.lastInventoryDate())) {
            return false;
        }
        if (other.numberOfArchives() == null ^ this.numberOfArchives() == null) {
            return false;
        }
        if (other.numberOfArchives() != null && !other.numberOfArchives().equals(this.numberOfArchives())) {
            return false;
        }
        if (other.sizeInBytes() == null ^ this.sizeInBytes() == null) {
            return false;
        }
        return other.sizeInBytes() == null || other.sizeInBytes().equals(this.sizeInBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vaultARN() != null) {
            sb.append("VaultARN: ").append(this.vaultARN()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastInventoryDate() != null) {
            sb.append("LastInventoryDate: ").append(this.lastInventoryDate()).append(",");
        }
        if (this.numberOfArchives() != null) {
            sb.append("NumberOfArchives: ").append(this.numberOfArchives()).append(",");
        }
        if (this.sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(this.sizeInBytes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultARN": {
                return Optional.of(clazz.cast(this.vaultARN()));
            }
            case "VaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "LastInventoryDate": {
                return Optional.of(clazz.cast(this.lastInventoryDate()));
            }
            case "NumberOfArchives": {
                return Optional.of(clazz.cast(this.numberOfArchives()));
            }
            case "SizeInBytes": {
                return Optional.of(clazz.cast(this.sizeInBytes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String vaultARN;
        private String vaultName;
        private String creationDate;
        private String lastInventoryDate;
        private Long numberOfArchives;
        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVaultResponse model) {
            this.vaultARN(model.vaultARN);
            this.vaultName(model.vaultName);
            this.creationDate(model.creationDate);
            this.lastInventoryDate(model.lastInventoryDate);
            this.numberOfArchives(model.numberOfArchives);
            this.sizeInBytes(model.sizeInBytes);
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getLastInventoryDate() {
            return this.lastInventoryDate;
        }

        @Override
        public final Builder lastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
            return this;
        }

        public final void setLastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
        }

        public final Long getNumberOfArchives() {
            return this.numberOfArchives;
        }

        @Override
        public final Builder numberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
            return this;
        }

        public final void setNumberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public DescribeVaultResponse build() {
            return new DescribeVaultResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVaultResponse> {
        public Builder vaultARN(String var1);

        public Builder vaultName(String var1);

        public Builder creationDate(String var1);

        public Builder lastInventoryDate(String var1);

        public Builder numberOfArchives(Long var1);

        public Builder sizeInBytes(Long var1);
    }
}

