/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.DataRetrievalRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DataRetrievalRule
implements StructuredPojo,
ToCopyableBuilder<Builder, DataRetrievalRule> {
    private final String strategy;
    private final Long bytesPerHour;

    private DataRetrievalRule(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.bytesPerHour = builder.bytesPerHour;
    }

    public String strategy() {
        return this.strategy;
    }

    public Long bytesPerHour() {
        return this.bytesPerHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.strategy() == null ? 0 : this.strategy().hashCode());
        hashCode = 31 * hashCode + (this.bytesPerHour() == null ? 0 : this.bytesPerHour().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalRule)) {
            return false;
        }
        DataRetrievalRule other = (DataRetrievalRule)obj;
        if (other.strategy() == null ^ this.strategy() == null) {
            return false;
        }
        if (other.strategy() != null && !other.strategy().equals(this.strategy())) {
            return false;
        }
        if (other.bytesPerHour() == null ^ this.bytesPerHour() == null) {
            return false;
        }
        return other.bytesPerHour() == null || other.bytesPerHour().equals(this.bytesPerHour());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.strategy() != null) {
            sb.append("Strategy: ").append(this.strategy()).append(",");
        }
        if (this.bytesPerHour() != null) {
            sb.append("BytesPerHour: ").append(this.bytesPerHour()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.of(clazz.cast(this.strategy()));
            }
            case "BytesPerHour": {
                return Optional.of(clazz.cast(this.bytesPerHour()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataRetrievalRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private Long bytesPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRetrievalRule model) {
            this.strategy(model.strategy);
            this.bytesPerHour(model.bytesPerHour);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Long getBytesPerHour() {
            return this.bytesPerHour;
        }

        @Override
        public final Builder bytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
            return this;
        }

        public final void setBytesPerHour(Long bytesPerHour) {
            this.bytesPerHour = bytesPerHour;
        }

        public DataRetrievalRule build() {
            return new DataRetrievalRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataRetrievalRule> {
        public Builder strategy(String var1);

        public Builder bytesPerHour(Long var1);
    }
}

