/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.VaultNotificationConfig;

@SdkInternalApi
public class VaultNotificationConfigMarshaller {
    private static final MarshallingInfo<String> SNSTOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopic").build();
    private static final MarshallingInfo<List> EVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Events").build();
    private static final VaultNotificationConfigMarshaller INSTANCE = new VaultNotificationConfigMarshaller();

    public static VaultNotificationConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VaultNotificationConfig vaultNotificationConfig, ProtocolMarshaller protocolMarshaller) {
        if (vaultNotificationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vaultNotificationConfig.snsTopic(), SNSTOPIC_BINDING);
            protocolMarshaller.marshall(vaultNotificationConfig.events(), EVENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

