/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.PartListElement;

public class PartListElementUnmarshaller
implements Unmarshaller<PartListElement, JsonUnmarshallerContext> {
    private static final PartListElementUnmarshaller INSTANCE = new PartListElementUnmarshaller();

    public PartListElement unmarshall(JsonUnmarshallerContext context) throws Exception {
        PartListElement.Builder partListElementBuilder = PartListElement.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RangeInBytes", targetDepth)) {
                    context.nextToken();
                    partListElementBuilder.rangeInBytes((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SHA256TreeHash", targetDepth)) {
                    context.nextToken();
                    partListElementBuilder.sha256TreeHash((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PartListElement)partListElementBuilder.build();
    }

    public static PartListElementUnmarshaller getInstance() {
        return INSTANCE;
    }
}

