/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.UploadListElementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadListElement
implements StructuredPojo,
ToCopyableBuilder<Builder, UploadListElement> {
    private final String multipartUploadId;
    private final String vaultARN;
    private final String archiveDescription;
    private final Long partSizeInBytes;
    private final String creationDate;

    private UploadListElement(BuilderImpl builder) {
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
    }

    public String multipartUploadId() {
        return this.multipartUploadId;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Long partSizeInBytes() {
        return this.partSizeInBytes;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.multipartUploadId() == null ? 0 : this.multipartUploadId().hashCode());
        hashCode = 31 * hashCode + (this.vaultARN() == null ? 0 : this.vaultARN().hashCode());
        hashCode = 31 * hashCode + (this.archiveDescription() == null ? 0 : this.archiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.partSizeInBytes() == null ? 0 : this.partSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadListElement)) {
            return false;
        }
        UploadListElement other = (UploadListElement)obj;
        if (other.multipartUploadId() == null ^ this.multipartUploadId() == null) {
            return false;
        }
        if (other.multipartUploadId() != null && !other.multipartUploadId().equals(this.multipartUploadId())) {
            return false;
        }
        if (other.vaultARN() == null ^ this.vaultARN() == null) {
            return false;
        }
        if (other.vaultARN() != null && !other.vaultARN().equals(this.vaultARN())) {
            return false;
        }
        if (other.archiveDescription() == null ^ this.archiveDescription() == null) {
            return false;
        }
        if (other.archiveDescription() != null && !other.archiveDescription().equals(this.archiveDescription())) {
            return false;
        }
        if (other.partSizeInBytes() == null ^ this.partSizeInBytes() == null) {
            return false;
        }
        if (other.partSizeInBytes() != null && !other.partSizeInBytes().equals(this.partSizeInBytes())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        return other.creationDate() == null || other.creationDate().equals(this.creationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.multipartUploadId() != null) {
            sb.append("MultipartUploadId: ").append(this.multipartUploadId()).append(",");
        }
        if (this.vaultARN() != null) {
            sb.append("VaultARN: ").append(this.vaultARN()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (this.partSizeInBytes() != null) {
            sb.append("PartSizeInBytes: ").append(this.partSizeInBytes()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadListElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String multipartUploadId;
        private String vaultARN;
        private String archiveDescription;
        private Long partSizeInBytes;
        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadListElement model) {
            this.setMultipartUploadId(model.multipartUploadId);
            this.setVaultARN(model.vaultARN);
            this.setArchiveDescription(model.archiveDescription);
            this.setPartSizeInBytes(model.partSizeInBytes);
            this.setCreationDate(model.creationDate);
        }

        public final String getMultipartUploadId() {
            return this.multipartUploadId;
        }

        @Override
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final Long getPartSizeInBytes() {
            return this.partSizeInBytes;
        }

        @Override
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public UploadListElement build() {
            return new UploadListElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadListElement> {
        public Builder multipartUploadId(String var1);

        public Builder vaultARN(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSizeInBytes(Long var1);

        public Builder creationDate(String var1);
    }
}

