/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteVaultLockRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompleteVaultLockRequest> {
    private final String accountId;
    private final String vaultName;
    private final String lockId;

    private CompleteVaultLockRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.lockId = builder.lockId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String lockId() {
        return this.lockId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.lockId() == null ? 0 : this.lockId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteVaultLockRequest)) {
            return false;
        }
        CompleteVaultLockRequest other = (CompleteVaultLockRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.lockId() == null ^ this.lockId() == null) {
            return false;
        }
        return other.lockId() == null || other.lockId().equals(this.lockId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.lockId() != null) {
            sb.append("LockId: ").append(this.lockId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String lockId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteVaultLockRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setLockId(model.lockId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getLockId() {
            return this.lockId;
        }

        @Override
        public final Builder lockId(String lockId) {
            this.lockId = lockId;
            return this;
        }

        public final void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public CompleteVaultLockRequest build() {
            return new CompleteVaultLockRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompleteVaultLockRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder lockId(String var1);
    }
}

