/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteMultipartUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompleteMultipartUploadRequest> {
    private final String accountId;
    private final String vaultName;
    private final String uploadId;
    private final String archiveSize;
    private final String checksum;

    private CompleteMultipartUploadRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.uploadId = builder.uploadId;
        this.archiveSize = builder.archiveSize;
        this.checksum = builder.checksum;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String archiveSize() {
        return this.archiveSize;
    }

    public String checksum() {
        return this.checksum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.archiveSize() == null ? 0 : this.archiveSize().hashCode());
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadRequest)) {
            return false;
        }
        CompleteMultipartUploadRequest other = (CompleteMultipartUploadRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.archiveSize() == null ^ this.archiveSize() == null) {
            return false;
        }
        if (other.archiveSize() != null && !other.archiveSize().equals(this.archiveSize())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        return other.checksum() == null || other.checksum().equals(this.checksum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.archiveSize() != null) {
            sb.append("ArchiveSize: ").append(this.archiveSize()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String uploadId;
        private String archiveSize;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setUploadId(model.uploadId);
            this.setArchiveSize(model.archiveSize);
            this.setChecksum(model.checksum);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getArchiveSize() {
            return this.archiveSize;
        }

        @Override
        public final Builder archiveSize(String archiveSize) {
            this.archiveSize = archiveSize;
            return this;
        }

        public final void setArchiveSize(String archiveSize) {
            this.archiveSize = archiveSize;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompleteMultipartUploadRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder uploadId(String var1);

        public Builder archiveSize(String var1);

        public Builder checksum(String var1);
    }
}

