/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription;

@SdkInternalApi
public class ProvisionedCapacityDescriptionMarshaller {
    private static final MarshallingInfo<String> CAPACITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityId").build();
    private static final MarshallingInfo<String> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").build();
    private static final MarshallingInfo<String> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").build();
    private static final ProvisionedCapacityDescriptionMarshaller instance = new ProvisionedCapacityDescriptionMarshaller();

    public static ProvisionedCapacityDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProvisionedCapacityDescription provisionedCapacityDescription, ProtocolMarshaller protocolMarshaller) {
        if (provisionedCapacityDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.capacityId(), CAPACITYID_BINDING);
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)provisionedCapacityDescription.expirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

