/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;

@SdkInternalApi
public class DescribeVaultOutputMarshaller {
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultName").build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<String> LASTINVENTORYDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastInventoryDate").build();
    private static final MarshallingInfo<Long> NUMBEROFARCHIVES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfArchives").build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final DescribeVaultOutputMarshaller instance = new DescribeVaultOutputMarshaller();

    public static DescribeVaultOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(DescribeVaultOutput describeVaultOutput, ProtocolMarshaller protocolMarshaller) {
        if (describeVaultOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)describeVaultOutput.vaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.lastInventoryDate(), LASTINVENTORYDATE_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.numberOfArchives(), NUMBEROFARCHIVES_BINDING);
            protocolMarshaller.marshall((Object)describeVaultOutput.sizeInBytes(), SIZEINBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

