/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRule;

@SdkInternalApi
public class DataRetrievalRuleMarshaller {
    private static final MarshallingInfo<String> STRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Strategy").build();
    private static final MarshallingInfo<Long> BYTESPERHOUR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesPerHour").build();
    private static final DataRetrievalRuleMarshaller instance = new DataRetrievalRuleMarshaller();

    public static DataRetrievalRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataRetrievalRule dataRetrievalRule, ProtocolMarshaller protocolMarshaller) {
        if (dataRetrievalRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataRetrievalRule.strategy(), STRATEGY_BINDING);
            protocolMarshaller.marshall((Object)dataRetrievalRule.bytesPerHour(), BYTESPERHOUR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

