/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.services.glacier.model.JobListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private final List<GlacierJobDescription> jobList;
    private final String marker;

    private ListJobsResponse(BuilderImpl builder) {
        this.jobList = builder.jobList;
        this.marker = builder.marker;
    }

    public List<GlacierJobDescription> jobList() {
        return this.jobList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobList() == null ? 0 : this.jobList().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        if (other.jobList() == null ^ this.jobList() == null) {
            return false;
        }
        if (other.jobList() != null && !other.jobList().equals(this.jobList())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobList() != null) {
            sb.append("JobList: ").append(this.jobList()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GlacierJobDescription> jobList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            this.setJobList(model.jobList);
            this.setMarker(model.marker);
        }

        public final Collection<GlacierJobDescription> getJobList() {
            return this.jobList;
        }

        @Override
        public final Builder jobList(Collection<GlacierJobDescription> jobList) {
            this.jobList = JobListCopier.copy(jobList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobList(GlacierJobDescription ... jobList) {
            this.jobList(Arrays.asList(jobList));
            return this;
        }

        public final void setJobList(Collection<GlacierJobDescription> jobList) {
            this.jobList = JobListCopier.copy(jobList);
        }

        @SafeVarargs
        public final void setJobList(GlacierJobDescription ... jobList) {
            this.jobList(Arrays.asList(jobList));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobList(Collection<GlacierJobDescription> var1);

        public Builder jobList(GlacierJobDescription ... var1);

        public Builder marker(String var1);
    }
}

