/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateMultipartUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, InitiateMultipartUploadRequest> {
    private final String accountId;
    private final String vaultName;
    private final String archiveDescription;
    private final String partSize;

    private InitiateMultipartUploadRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.archiveDescription = builder.archiveDescription;
        this.partSize = builder.partSize;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public String partSize() {
        return this.partSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.archiveDescription() == null ? 0 : this.archiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.partSize() == null ? 0 : this.partSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateMultipartUploadRequest)) {
            return false;
        }
        InitiateMultipartUploadRequest other = (InitiateMultipartUploadRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.archiveDescription() == null ^ this.archiveDescription() == null) {
            return false;
        }
        if (other.archiveDescription() != null && !other.archiveDescription().equals(this.archiveDescription())) {
            return false;
        }
        if (other.partSize() == null ^ this.partSize() == null) {
            return false;
        }
        return other.partSize() == null || other.partSize().equals(this.partSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (this.partSize() != null) {
            sb.append("PartSize: ").append(this.partSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String archiveDescription;
        private String partSize;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateMultipartUploadRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setArchiveDescription(model.archiveDescription);
            this.setPartSize(model.partSize);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final String getPartSize() {
            return this.partSize;
        }

        @Override
        public final Builder partSize(String partSize) {
            this.partSize = partSize;
            return this;
        }

        public final void setPartSize(String partSize) {
            this.partSize = partSize;
        }

        public InitiateMultipartUploadRequest build() {
            return new InitiateMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InitiateMultipartUploadRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSize(String var1);
    }
}

