/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.transform.ListMultipartUploadsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/{accountId}/vaults/{vaultName}/multipart-uploads").httpMethodName(HttpMethodName.GET).hasExplicitPayloadMember(false).hasPayloadMembers(false).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ListMultipartUploadsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        Validate.paramNotNull((Object)((Object)listMultipartUploadsRequest), (String)"listMultipartUploadsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listMultipartUploadsRequest);
            protocolMarshaller.startMarshalling();
            ListMultipartUploadsRequestModelMarshaller.getInstance().marshall(listMultipartUploadsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

