/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListJobsRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("statuscode").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("completed").isBinary(false).build();
    private static final ListJobsRequestModelMarshaller INSTANCE = new ListJobsRequestModelMarshaller();

    private ListJobsRequestModelMarshaller() {
    }

    public static ListJobsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListJobsRequest listJobsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listJobsRequest), (String)"listJobsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listJobsRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.statuscode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.completed(), COMPLETED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

