/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;

public class GetJobOutputResponseUnmarshaller
implements Unmarshaller<GetJobOutputResponse, JsonUnmarshallerContext> {
    private static final GetJobOutputResponseUnmarshaller INSTANCE = new GetJobOutputResponseUnmarshaller();

    public GetJobOutputResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetJobOutputResponse.Builder getJobOutputResponseBuilder = GetJobOutputResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("x-amz-sha256-tree-hash") != null) {
                context.setCurrentHeader("x-amz-sha256-tree-hash");
                getJobOutputResponseBuilder.checksum((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Range") != null) {
                context.setCurrentHeader("Content-Range");
                getJobOutputResponseBuilder.contentRange((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Accept-Ranges") != null) {
                context.setCurrentHeader("Accept-Ranges");
                getJobOutputResponseBuilder.acceptRanges((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getJobOutputResponseBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("x-amz-archive-description") != null) {
                context.setCurrentHeader("x-amz-archive-description");
                getJobOutputResponseBuilder.archiveDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
        }
        getJobOutputResponseBuilder.status(context.getHttpResponse().getStatusCode());
        return (GetJobOutputResponse)((Object)getJobOutputResponseBuilder.build());
    }

    public static GetJobOutputResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

