/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.PartListElement;

public class ListPartsIterable
implements SdkIterable<ListPartsResponse> {
    private final GlacierClient client;
    private final ListPartsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPartsIterable(GlacierClient client, ListPartsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPartsResponseFetcher();
    }

    public Iterator<ListPartsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<PartListElement> parts() {
        Function<ListPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListPartsIterable resume(ListPartsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPartsIterable(this.client, (ListPartsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListPartsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPartsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPartsResponseFetcher
    implements SyncPageFetcher<ListPartsResponse> {
        private ListPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListPartsResponse nextPage(ListPartsResponse previousPage) {
            if (previousPage == null) {
                return ListPartsIterable.this.client.listParts(ListPartsIterable.this.firstRequest);
            }
            return ListPartsIterable.this.client.listParts((ListPartsRequest)((Object)ListPartsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

