/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;
import software.amazon.awssdk.services.glacier.model.UploadsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListMultipartUploadsResponse> {
    private final List<UploadListElement> uploadsList;
    private final String marker;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploadsList = builder.uploadsList;
        this.marker = builder.marker;
    }

    public List<UploadListElement> uploadsList() {
        return this.uploadsList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse)((Object)obj);
        return Objects.equals(this.uploadsList(), other.uploadsList()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListMultipartUploadsResponse").add("UploadsList", this.uploadsList()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadsList": {
                return Optional.of(clazz.cast(this.uploadsList()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<UploadListElement> uploadsList;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            super(model);
            this.uploadsList(model.uploadsList);
            this.marker(model.marker);
        }

        public final Collection<UploadListElement.Builder> getUploadsList() {
            return this.uploadsList != null ? (Collection)this.uploadsList.stream().map(UploadListElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploadsList(Collection<UploadListElement> uploadsList) {
            this.uploadsList = UploadsListCopier.copy(uploadsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(UploadListElement ... uploadsList) {
            this.uploadsList(Arrays.asList(uploadsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadsList(Consumer<UploadListElement.Builder> ... uploadsList) {
            this.uploadsList(Stream.of(uploadsList).map(c -> (UploadListElement)((UploadListElement.Builder)UploadListElement.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUploadsList(Collection<UploadListElement.BuilderImpl> uploadsList) {
            this.uploadsList = UploadsListCopier.copyFromBuilder(uploadsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        public Builder uploadsList(Collection<UploadListElement> var1);

        public Builder uploadsList(UploadListElement ... var1);

        public Builder uploadsList(Consumer<UploadListElement.Builder> ... var1);

        public Builder marker(String var1);
    }
}

