/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.internal;

import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;

public class GlacierExecutionInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)((SdkHttpFullRequest.Builder)request.toBuilder()).apply(b -> this.beforeRequest(originalRequest, (SdkHttpFullRequest.Builder)b))).build();
    }

    private SdkHttpFullRequest.Builder beforeRequest(Object originalRequest, SdkHttpFullRequest.Builder mutableRequest) {
        String resourcePath;
        mutableRequest.header("x-amz-glacier-version", "2012-06-01");
        mutableRequest.header("x-amz-content-sha256", "required");
        if (originalRequest instanceof UploadMultipartPartRequest) {
            mutableRequest.firstMatchingHeader("Content-Range").ifPresent(range -> mutableRequest.header("Content-Length", Long.toString(this.parseContentLengthFromRange((String)range))));
        } else if ((originalRequest instanceof GetJobOutputRequest || originalRequest instanceof DescribeJobRequest) && (resourcePath = mutableRequest.encodedPath()) != null) {
            String newResourcePath = resourcePath.replace("{jobType}", "archive-retrievals");
            mutableRequest.encodedPath(newResourcePath);
        }
        return mutableRequest;
    }

    private long parseContentLengthFromRange(String range) {
        if (range.startsWith("bytes=") || range.startsWith("bytes ")) {
            range = range.substring(6);
        }
        String start = range.substring(0, range.indexOf(45));
        String end = range.substring(range.indexOf(45) + 1);
        if (end.contains("/")) {
            end = end.substring(0, end.indexOf("/"));
        }
        return Long.parseLong(end) - Long.parseLong(start) + 1L;
    }
}

