/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RoadSnapHazardousCargoType;
import software.amazon.awssdk.services.georoutes.model.RoadSnapHazardousCargoTypeListCopier;
import software.amazon.awssdk.services.georoutes.model.RoadSnapTrailerOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoadSnapTruckOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoadSnapTruckOptions> {
    private static final SdkField<Long> GROSS_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("GrossWeight").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::grossWeight)).setter(RoadSnapTruckOptions.setter(Builder::grossWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrossWeight").build()}).build();
    private static final SdkField<List<String>> HAZARDOUS_CARGOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HazardousCargos").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::hazardousCargosAsStrings)).setter(RoadSnapTruckOptions.setter(Builder::hazardousCargosWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HazardousCargos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Height").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::height)).setter(RoadSnapTruckOptions.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<Long> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Length").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::length)).setter(RoadSnapTruckOptions.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()}).build();
    private static final SdkField<RoadSnapTrailerOptions> TRAILER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Trailer").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::trailer)).setter(RoadSnapTruckOptions.setter(Builder::trailer)).constructor(RoadSnapTrailerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trailer").build()}).build();
    private static final SdkField<String> TUNNEL_RESTRICTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelRestrictionCode").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::tunnelRestrictionCode)).setter(RoadSnapTruckOptions.setter(Builder::tunnelRestrictionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelRestrictionCode").build()}).build();
    private static final SdkField<Long> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Width").getter(RoadSnapTruckOptions.getter(RoadSnapTruckOptions::width)).setter(RoadSnapTruckOptions.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROSS_WEIGHT_FIELD, HAZARDOUS_CARGOS_FIELD, HEIGHT_FIELD, LENGTH_FIELD, TRAILER_FIELD, TUNNEL_RESTRICTION_CODE_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoadSnapTruckOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long grossWeight;
    private final List<String> hazardousCargos;
    private final Long height;
    private final Long length;
    private final RoadSnapTrailerOptions trailer;
    private final String tunnelRestrictionCode;
    private final Long width;

    private RoadSnapTruckOptions(BuilderImpl builder) {
        this.grossWeight = builder.grossWeight;
        this.hazardousCargos = builder.hazardousCargos;
        this.height = builder.height;
        this.length = builder.length;
        this.trailer = builder.trailer;
        this.tunnelRestrictionCode = builder.tunnelRestrictionCode;
        this.width = builder.width;
    }

    public final Long grossWeight() {
        return this.grossWeight;
    }

    public final List<RoadSnapHazardousCargoType> hazardousCargos() {
        return RoadSnapHazardousCargoTypeListCopier.copyStringToEnum(this.hazardousCargos);
    }

    public final boolean hasHazardousCargos() {
        return this.hazardousCargos != null && !(this.hazardousCargos instanceof SdkAutoConstructList);
    }

    public final List<String> hazardousCargosAsStrings() {
        return this.hazardousCargos;
    }

    public final Long height() {
        return this.height;
    }

    public final Long length() {
        return this.length;
    }

    public final RoadSnapTrailerOptions trailer() {
        return this.trailer;
    }

    public final String tunnelRestrictionCode() {
        return this.tunnelRestrictionCode;
    }

    public final Long width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grossWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHazardousCargos() ? this.hazardousCargosAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.trailer());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelRestrictionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapTruckOptions)) {
            return false;
        }
        RoadSnapTruckOptions other = (RoadSnapTruckOptions)obj;
        return Objects.equals(this.grossWeight(), other.grossWeight()) && this.hasHazardousCargos() == other.hasHazardousCargos() && Objects.equals(this.hazardousCargosAsStrings(), other.hazardousCargosAsStrings()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.trailer(), other.trailer()) && Objects.equals(this.tunnelRestrictionCode(), other.tunnelRestrictionCode()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"RoadSnapTruckOptions").add("GrossWeight", (Object)this.grossWeight()).add("HazardousCargos", this.hasHazardousCargos() ? this.hazardousCargosAsStrings() : null).add("Height", (Object)this.height()).add("Length", (Object)this.length()).add("Trailer", (Object)this.trailer()).add("TunnelRestrictionCode", (Object)this.tunnelRestrictionCode()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrossWeight": {
                return Optional.ofNullable(clazz.cast(this.grossWeight()));
            }
            case "HazardousCargos": {
                return Optional.ofNullable(clazz.cast(this.hazardousCargosAsStrings()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Trailer": {
                return Optional.ofNullable(clazz.cast(this.trailer()));
            }
            case "TunnelRestrictionCode": {
                return Optional.ofNullable(clazz.cast(this.tunnelRestrictionCode()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GrossWeight", GROSS_WEIGHT_FIELD);
        map.put("HazardousCargos", HAZARDOUS_CARGOS_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("Length", LENGTH_FIELD);
        map.put("Trailer", TRAILER_FIELD);
        map.put("TunnelRestrictionCode", TUNNEL_RESTRICTION_CODE_FIELD);
        map.put("Width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapTruckOptions, T> g) {
        return obj -> g.apply((RoadSnapTruckOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long grossWeight;
        private List<String> hazardousCargos = DefaultSdkAutoConstructList.getInstance();
        private Long height;
        private Long length;
        private RoadSnapTrailerOptions trailer;
        private String tunnelRestrictionCode;
        private Long width;

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapTruckOptions model) {
            this.grossWeight(model.grossWeight);
            this.hazardousCargosWithStrings(model.hazardousCargos);
            this.height(model.height);
            this.length(model.length);
            this.trailer(model.trailer);
            this.tunnelRestrictionCode(model.tunnelRestrictionCode);
            this.width(model.width);
        }

        public final Long getGrossWeight() {
            return this.grossWeight;
        }

        public final void setGrossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
        }

        @Override
        public final Builder grossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
            return this;
        }

        public final Collection<String> getHazardousCargos() {
            if (this.hazardousCargos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hazardousCargos;
        }

        public final void setHazardousCargos(Collection<String> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copy(hazardousCargos);
        }

        @Override
        public final Builder hazardousCargosWithStrings(Collection<String> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copy(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargosWithStrings(String ... hazardousCargos) {
            this.hazardousCargosWithStrings(Arrays.asList(hazardousCargos));
            return this;
        }

        @Override
        public final Builder hazardousCargos(Collection<RoadSnapHazardousCargoType> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copyEnumToString(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargos(RoadSnapHazardousCargoType ... hazardousCargos) {
            this.hazardousCargos(Arrays.asList(hazardousCargos));
            return this;
        }

        public final Long getHeight() {
            return this.height;
        }

        public final void setHeight(Long height) {
            this.height = height;
        }

        @Override
        public final Builder height(Long height) {
            this.height = height;
            return this;
        }

        public final Long getLength() {
            return this.length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final RoadSnapTrailerOptions.Builder getTrailer() {
            return this.trailer != null ? this.trailer.toBuilder() : null;
        }

        public final void setTrailer(RoadSnapTrailerOptions.BuilderImpl trailer) {
            this.trailer = trailer != null ? trailer.build() : null;
        }

        @Override
        public final Builder trailer(RoadSnapTrailerOptions trailer) {
            this.trailer = trailer;
            return this;
        }

        public final String getTunnelRestrictionCode() {
            return this.tunnelRestrictionCode;
        }

        public final void setTunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
        }

        @Override
        public final Builder tunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
            return this;
        }

        public final Long getWidth() {
            return this.width;
        }

        public final void setWidth(Long width) {
            this.width = width;
        }

        @Override
        public final Builder width(Long width) {
            this.width = width;
            return this;
        }

        public RoadSnapTruckOptions build() {
            return new RoadSnapTruckOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoadSnapTruckOptions> {
        public Builder grossWeight(Long var1);

        public Builder hazardousCargosWithStrings(Collection<String> var1);

        public Builder hazardousCargosWithStrings(String ... var1);

        public Builder hazardousCargos(Collection<RoadSnapHazardousCargoType> var1);

        public Builder hazardousCargos(RoadSnapHazardousCargoType ... var1);

        public Builder height(Long var1);

        public Builder length(Long var1);

        public Builder trailer(RoadSnapTrailerOptions var1);

        default public Builder trailer(Consumer<RoadSnapTrailerOptions.Builder> trailer) {
            return this.trailer((RoadSnapTrailerOptions)((RoadSnapTrailerOptions.Builder)RoadSnapTrailerOptions.builder().applyMutation(trailer)).build());
        }

        public Builder tunnelRestrictionCode(String var1);

        public Builder width(Long var1);
    }
}

