/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoadSnapSnappedTracePoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoadSnapSnappedTracePoint> {
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Confidence").getter(RoadSnapSnappedTracePoint.getter(RoadSnapSnappedTracePoint::confidence)).setter(RoadSnapSnappedTracePoint.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<Double>> ORIGINAL_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OriginalPosition").getter(RoadSnapSnappedTracePoint.getter(RoadSnapSnappedTracePoint::originalPosition)).setter(RoadSnapSnappedTracePoint.setter(Builder::originalPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> SNAPPED_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedPosition").getter(RoadSnapSnappedTracePoint.getter(RoadSnapSnappedTracePoint::snappedPosition)).setter(RoadSnapSnappedTracePoint.setter(Builder::snappedPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_FIELD, ORIGINAL_POSITION_FIELD, SNAPPED_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoadSnapSnappedTracePoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double confidence;
    private final List<Double> originalPosition;
    private final List<Double> snappedPosition;

    private RoadSnapSnappedTracePoint(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.originalPosition = builder.originalPosition;
        this.snappedPosition = builder.snappedPosition;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public final boolean hasOriginalPosition() {
        return this.originalPosition != null && !(this.originalPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> originalPosition() {
        return this.originalPosition;
    }

    public final boolean hasSnappedPosition() {
        return this.snappedPosition != null && !(this.snappedPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> snappedPosition() {
        return this.snappedPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOriginalPosition() ? this.originalPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedPosition() ? this.snappedPosition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapSnappedTracePoint)) {
            return false;
        }
        RoadSnapSnappedTracePoint other = (RoadSnapSnappedTracePoint)obj;
        return Objects.equals(this.confidence(), other.confidence()) && this.hasOriginalPosition() == other.hasOriginalPosition() && Objects.equals(this.originalPosition(), other.originalPosition()) && this.hasSnappedPosition() == other.hasSnappedPosition() && Objects.equals(this.snappedPosition(), other.snappedPosition());
    }

    public final String toString() {
        return ToString.builder((String)"RoadSnapSnappedTracePoint").add("Confidence", (Object)this.confidence()).add("OriginalPosition", (Object)(this.originalPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("SnappedPosition", (Object)(this.snappedPosition() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "OriginalPosition": {
                return Optional.ofNullable(clazz.cast(this.originalPosition()));
            }
            case "SnappedPosition": {
                return Optional.ofNullable(clazz.cast(this.snappedPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("OriginalPosition", ORIGINAL_POSITION_FIELD);
        map.put("SnappedPosition", SNAPPED_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapSnappedTracePoint, T> g) {
        return obj -> g.apply((RoadSnapSnappedTracePoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double confidence;
        private List<Double> originalPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> snappedPosition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapSnappedTracePoint model) {
            this.confidence(model.confidence);
            this.originalPosition(model.originalPosition);
            this.snappedPosition(model.snappedPosition);
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Collection<Double> getOriginalPosition() {
            if (this.originalPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.originalPosition;
        }

        public final void setOriginalPosition(Collection<Double> originalPosition) {
            this.originalPosition = PositionCopier.copy(originalPosition);
        }

        @Override
        public final Builder originalPosition(Collection<Double> originalPosition) {
            this.originalPosition = PositionCopier.copy(originalPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originalPosition(Double ... originalPosition) {
            this.originalPosition(Arrays.asList(originalPosition));
            return this;
        }

        public final Collection<Double> getSnappedPosition() {
            if (this.snappedPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snappedPosition;
        }

        public final void setSnappedPosition(Collection<Double> snappedPosition) {
            this.snappedPosition = PositionCopier.copy(snappedPosition);
        }

        @Override
        public final Builder snappedPosition(Collection<Double> snappedPosition) {
            this.snappedPosition = PositionCopier.copy(snappedPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedPosition(Double ... snappedPosition) {
            this.snappedPosition(Arrays.asList(snappedPosition));
            return this;
        }

        public RoadSnapSnappedTracePoint build() {
            return new RoadSnapSnappedTracePoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoadSnapSnappedTracePoint> {
        public Builder confidence(Double var1);

        public Builder originalPosition(Collection<Double> var1);

        public Builder originalPosition(Double ... var1);

        public Builder snappedPosition(Collection<Double> var1);

        public Builder snappedPosition(Double ... var1);
    }
}

