/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LineStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Corridor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Corridor> {
    private static final SdkField<List<List<Double>>> LINE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineString").getter(Corridor.getter(Corridor::lineString)).setter(Corridor.setter(Builder::lineString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineString").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Radius").getter(Corridor.getter(Corridor::radius)).setter(Corridor.setter(Builder::radius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_STRING_FIELD, RADIUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Corridor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<Double>> lineString;
    private final Integer radius;

    private Corridor(BuilderImpl builder) {
        this.lineString = builder.lineString;
        this.radius = builder.radius;
    }

    public final boolean hasLineString() {
        return this.lineString != null && !(this.lineString instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> lineString() {
        return this.lineString;
    }

    public final Integer radius() {
        return this.radius;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineString() ? this.lineString() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.radius());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Corridor)) {
            return false;
        }
        Corridor other = (Corridor)obj;
        return this.hasLineString() == other.hasLineString() && Objects.equals(this.lineString(), other.lineString()) && Objects.equals(this.radius(), other.radius());
    }

    public final String toString() {
        return ToString.builder((String)"Corridor").add("LineString", (Object)(this.lineString() == null ? null : "*** Sensitive Data Redacted ***")).add("Radius", (Object)this.radius()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineString": {
                return Optional.ofNullable(clazz.cast(this.lineString()));
            }
            case "Radius": {
                return Optional.ofNullable(clazz.cast(this.radius()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LineString", LINE_STRING_FIELD);
        map.put("Radius", RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Corridor, T> g) {
        return obj -> g.apply((Corridor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<Double>> lineString = DefaultSdkAutoConstructList.getInstance();
        private Integer radius;

        private BuilderImpl() {
        }

        private BuilderImpl(Corridor model) {
            this.lineString(model.lineString);
            this.radius(model.radius);
        }

        public final Collection<? extends Collection<Double>> getLineString() {
            if (this.lineString instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lineString;
        }

        public final void setLineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
        }

        @Override
        public final Builder lineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineString(Collection<Double> ... lineString) {
            this.lineString((Collection<? extends Collection<Double>>)Arrays.asList(lineString));
            return this;
        }

        public final Integer getRadius() {
            return this.radius;
        }

        public final void setRadius(Integer radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Integer radius) {
            this.radius = radius;
            return this;
        }

        public Corridor build() {
            return new Corridor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Corridor> {
        public Builder lineString(Collection<? extends Collection<Double>> var1);

        public Builder lineString(Collection<Double> ... var1);

        public Builder radius(Integer var1);
    }
}

