/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.Route;
import software.amazon.awssdk.services.georoutes.model.RouteListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteResponseNotice;
import software.amazon.awssdk.services.georoutes.model.RouteResponseNoticeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRoutesResponse
extends GeoRoutesResponse
implements ToCopyableBuilder<Builder, CalculateRoutesResponse> {
    private static final SdkField<String> LEG_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegGeometryFormat").getter(CalculateRoutesResponse.getter(CalculateRoutesResponse::legGeometryFormatAsString)).setter(CalculateRoutesResponse.setter(Builder::legGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegGeometryFormat").build()}).build();
    private static final SdkField<List<RouteResponseNotice>> NOTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notices").getter(CalculateRoutesResponse.getter(CalculateRoutesResponse::notices)).setter(CalculateRoutesResponse.setter(Builder::notices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteResponseNotice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(CalculateRoutesResponse.getter(CalculateRoutesResponse::pricingBucket)).setter(CalculateRoutesResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(CalculateRoutesResponse.getter(CalculateRoutesResponse::routes)).setter(CalculateRoutesResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEG_GEOMETRY_FORMAT_FIELD, NOTICES_FIELD, PRICING_BUCKET_FIELD, ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateRoutesResponse.memberNameToFieldInitializer();
    private final String legGeometryFormat;
    private final List<RouteResponseNotice> notices;
    private final String pricingBucket;
    private final List<Route> routes;

    private CalculateRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.legGeometryFormat = builder.legGeometryFormat;
        this.notices = builder.notices;
        this.pricingBucket = builder.pricingBucket;
        this.routes = builder.routes;
    }

    public final GeometryFormat legGeometryFormat() {
        return GeometryFormat.fromValue(this.legGeometryFormat);
    }

    public final String legGeometryFormatAsString() {
        return this.legGeometryFormat;
    }

    public final boolean hasNotices() {
        return this.notices != null && !(this.notices instanceof SdkAutoConstructList);
    }

    public final List<RouteResponseNotice> notices() {
        return this.notices;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<Route> routes() {
        return this.routes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.legGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotices() ? this.notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRoutesResponse)) {
            return false;
        }
        CalculateRoutesResponse other = (CalculateRoutesResponse)((Object)obj);
        return Objects.equals(this.legGeometryFormatAsString(), other.legGeometryFormatAsString()) && this.hasNotices() == other.hasNotices() && Objects.equals(this.notices(), other.notices()) && Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRoutesResponse").add("LegGeometryFormat", (Object)this.legGeometryFormatAsString()).add("Notices", this.hasNotices() ? this.notices() : null).add("PricingBucket", (Object)this.pricingBucket()).add("Routes", this.hasRoutes() ? this.routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LegGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.legGeometryFormatAsString()));
            }
            case "Notices": {
                return Optional.ofNullable(clazz.cast(this.notices()));
            }
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LegGeometryFormat", LEG_GEOMETRY_FORMAT_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("Routes", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRoutesResponse, T> g) {
        return obj -> g.apply((CalculateRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesResponse.BuilderImpl
    implements Builder {
        private String legGeometryFormat;
        private List<RouteResponseNotice> notices = DefaultSdkAutoConstructList.getInstance();
        private String pricingBucket;
        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRoutesResponse model) {
            super(model);
            this.legGeometryFormat(model.legGeometryFormat);
            this.notices(model.notices);
            this.pricingBucket(model.pricingBucket);
            this.routes(model.routes);
        }

        public final String getLegGeometryFormat() {
            return this.legGeometryFormat;
        }

        public final void setLegGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
        }

        @Override
        public final Builder legGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
            return this;
        }

        @Override
        public final Builder legGeometryFormat(GeometryFormat legGeometryFormat) {
            this.legGeometryFormat(legGeometryFormat == null ? null : legGeometryFormat.toString());
            return this;
        }

        public final List<RouteResponseNotice.Builder> getNotices() {
            List<RouteResponseNotice.Builder> result = RouteResponseNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RouteResponseNotice.BuilderImpl> notices) {
            this.notices = RouteResponseNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RouteResponseNotice> notices) {
            this.notices = RouteResponseNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RouteResponseNotice ... notices) {
            this.notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RouteResponseNotice.Builder> ... notices) {
            this.notices(Stream.of(notices).map(c -> (RouteResponseNotice)((RouteResponseNotice.Builder)RouteResponseNotice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = RouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CalculateRoutesResponse build() {
            return new CalculateRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoRoutesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRoutesResponse> {
        public Builder legGeometryFormat(String var1);

        public Builder legGeometryFormat(GeometryFormat var1);

        public Builder notices(Collection<RouteResponseNotice> var1);

        public Builder notices(RouteResponseNotice ... var1);

        public Builder notices(Consumer<RouteResponseNotice.Builder> ... var1);

        public Builder pricingBucket(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder routes(Consumer<Route.Builder> ... var1);
    }
}

