/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.IsolineAllowOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineAvoidanceOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineDestinationOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineGranularityOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineOptimizationObjective;
import software.amazon.awssdk.services.georoutes.model.IsolineOriginOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineThresholds;
import software.amazon.awssdk.services.georoutes.model.IsolineTrafficOptions;
import software.amazon.awssdk.services.georoutes.model.IsolineTravelMode;
import software.amazon.awssdk.services.georoutes.model.IsolineTravelModeOptions;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.RoutingObjective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateIsolinesRequest
extends GeoRoutesRequest
implements ToCopyableBuilder<Builder, CalculateIsolinesRequest> {
    private static final SdkField<IsolineAllowOptions> ALLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Allow").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::allow)).setter(CalculateIsolinesRequest.setter(Builder::allow)).constructor(IsolineAllowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()}).build();
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArrivalTime").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::arrivalTime)).setter(CalculateIsolinesRequest.setter(Builder::arrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()}).build();
    private static final SdkField<IsolineAvoidanceOptions> AVOID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Avoid").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::avoid)).setter(CalculateIsolinesRequest.setter(Builder::avoid)).constructor(IsolineAvoidanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::departNow)).setter(CalculateIsolinesRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::departureTime)).setter(CalculateIsolinesRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<List<Double>> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destination").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::destination)).setter(CalculateIsolinesRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IsolineDestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationOptions").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::destinationOptions)).setter(CalculateIsolinesRequest.setter(Builder::destinationOptions)).constructor(IsolineDestinationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").build()}).build();
    private static final SdkField<String> ISOLINE_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsolineGeometryFormat").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::isolineGeometryFormatAsString)).setter(CalculateIsolinesRequest.setter(Builder::isolineGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolineGeometryFormat").build()}).build();
    private static final SdkField<IsolineGranularityOptions> ISOLINE_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IsolineGranularity").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::isolineGranularity)).setter(CalculateIsolinesRequest.setter(Builder::isolineGranularity)).constructor(IsolineGranularityOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsolineGranularity").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::key)).setter(CalculateIsolinesRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<String> OPTIMIZE_ISOLINE_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeIsolineFor").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::optimizeIsolineForAsString)).setter(CalculateIsolinesRequest.setter(Builder::optimizeIsolineFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeIsolineFor").build()}).build();
    private static final SdkField<String> OPTIMIZE_ROUTING_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeRoutingFor").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::optimizeRoutingForAsString)).setter(CalculateIsolinesRequest.setter(Builder::optimizeRoutingFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeRoutingFor").build()}).build();
    private static final SdkField<List<Double>> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Origin").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::origin)).setter(CalculateIsolinesRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IsolineOriginOptions> ORIGIN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginOptions").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::originOptions)).setter(CalculateIsolinesRequest.setter(Builder::originOptions)).constructor(IsolineOriginOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginOptions").build()}).build();
    private static final SdkField<IsolineThresholds> THRESHOLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Thresholds").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::thresholds)).setter(CalculateIsolinesRequest.setter(Builder::thresholds)).constructor(IsolineThresholds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thresholds").build()}).build();
    private static final SdkField<IsolineTrafficOptions> TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Traffic").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::traffic)).setter(CalculateIsolinesRequest.setter(Builder::traffic)).constructor(IsolineTrafficOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::travelModeAsString)).setter(CalculateIsolinesRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<IsolineTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TravelModeOptions").getter(CalculateIsolinesRequest.getter(CalculateIsolinesRequest::travelModeOptions)).setter(CalculateIsolinesRequest.setter(Builder::travelModeOptions)).constructor(IsolineTravelModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, ARRIVAL_TIME_FIELD, AVOID_FIELD, DEPART_NOW_FIELD, DEPARTURE_TIME_FIELD, DESTINATION_FIELD, DESTINATION_OPTIONS_FIELD, ISOLINE_GEOMETRY_FORMAT_FIELD, ISOLINE_GRANULARITY_FIELD, KEY_FIELD, OPTIMIZE_ISOLINE_FOR_FIELD, OPTIMIZE_ROUTING_FOR_FIELD, ORIGIN_FIELD, ORIGIN_OPTIONS_FIELD, THRESHOLDS_FIELD, TRAFFIC_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateIsolinesRequest.memberNameToFieldInitializer();
    private final IsolineAllowOptions allow;
    private final String arrivalTime;
    private final IsolineAvoidanceOptions avoid;
    private final Boolean departNow;
    private final String departureTime;
    private final List<Double> destination;
    private final IsolineDestinationOptions destinationOptions;
    private final String isolineGeometryFormat;
    private final IsolineGranularityOptions isolineGranularity;
    private final String key;
    private final String optimizeIsolineFor;
    private final String optimizeRoutingFor;
    private final List<Double> origin;
    private final IsolineOriginOptions originOptions;
    private final IsolineThresholds thresholds;
    private final IsolineTrafficOptions traffic;
    private final String travelMode;
    private final IsolineTravelModeOptions travelModeOptions;

    private CalculateIsolinesRequest(BuilderImpl builder) {
        super(builder);
        this.allow = builder.allow;
        this.arrivalTime = builder.arrivalTime;
        this.avoid = builder.avoid;
        this.departNow = builder.departNow;
        this.departureTime = builder.departureTime;
        this.destination = builder.destination;
        this.destinationOptions = builder.destinationOptions;
        this.isolineGeometryFormat = builder.isolineGeometryFormat;
        this.isolineGranularity = builder.isolineGranularity;
        this.key = builder.key;
        this.optimizeIsolineFor = builder.optimizeIsolineFor;
        this.optimizeRoutingFor = builder.optimizeRoutingFor;
        this.origin = builder.origin;
        this.originOptions = builder.originOptions;
        this.thresholds = builder.thresholds;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
    }

    public final IsolineAllowOptions allow() {
        return this.allow;
    }

    public final String arrivalTime() {
        return this.arrivalTime;
    }

    public final IsolineAvoidanceOptions avoid() {
        return this.avoid;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final boolean hasDestination() {
        return this.destination != null && !(this.destination instanceof SdkAutoConstructList);
    }

    public final List<Double> destination() {
        return this.destination;
    }

    public final IsolineDestinationOptions destinationOptions() {
        return this.destinationOptions;
    }

    public final GeometryFormat isolineGeometryFormat() {
        return GeometryFormat.fromValue(this.isolineGeometryFormat);
    }

    public final String isolineGeometryFormatAsString() {
        return this.isolineGeometryFormat;
    }

    public final IsolineGranularityOptions isolineGranularity() {
        return this.isolineGranularity;
    }

    public final String key() {
        return this.key;
    }

    public final IsolineOptimizationObjective optimizeIsolineFor() {
        return IsolineOptimizationObjective.fromValue(this.optimizeIsolineFor);
    }

    public final String optimizeIsolineForAsString() {
        return this.optimizeIsolineFor;
    }

    public final RoutingObjective optimizeRoutingFor() {
        return RoutingObjective.fromValue(this.optimizeRoutingFor);
    }

    public final String optimizeRoutingForAsString() {
        return this.optimizeRoutingFor;
    }

    public final boolean hasOrigin() {
        return this.origin != null && !(this.origin instanceof SdkAutoConstructList);
    }

    public final List<Double> origin() {
        return this.origin;
    }

    public final IsolineOriginOptions originOptions() {
        return this.originOptions;
    }

    public final IsolineThresholds thresholds() {
        return this.thresholds;
    }

    public final IsolineTrafficOptions traffic() {
        return this.traffic;
    }

    public final IsolineTravelMode travelMode() {
        return IsolineTravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final IsolineTravelModeOptions travelModeOptions() {
        return this.travelModeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allow());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoid());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestination() ? this.destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.isolineGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isolineGranularity());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeIsolineForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeRoutingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigin() ? this.origin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholds());
        hashCode = 31 * hashCode + Objects.hashCode(this.traffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateIsolinesRequest)) {
            return false;
        }
        CalculateIsolinesRequest other = (CalculateIsolinesRequest)((Object)obj);
        return Objects.equals(this.allow(), other.allow()) && Objects.equals(this.arrivalTime(), other.arrivalTime()) && Objects.equals(this.avoid(), other.avoid()) && Objects.equals(this.departNow(), other.departNow()) && Objects.equals(this.departureTime(), other.departureTime()) && this.hasDestination() == other.hasDestination() && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationOptions(), other.destinationOptions()) && Objects.equals(this.isolineGeometryFormatAsString(), other.isolineGeometryFormatAsString()) && Objects.equals(this.isolineGranularity(), other.isolineGranularity()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.optimizeIsolineForAsString(), other.optimizeIsolineForAsString()) && Objects.equals(this.optimizeRoutingForAsString(), other.optimizeRoutingForAsString()) && this.hasOrigin() == other.hasOrigin() && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.originOptions(), other.originOptions()) && Objects.equals(this.thresholds(), other.thresholds()) && Objects.equals(this.traffic(), other.traffic()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.travelModeOptions(), other.travelModeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateIsolinesRequest").add("Allow", (Object)this.allow()).add("ArrivalTime", (Object)this.arrivalTime()).add("Avoid", (Object)this.avoid()).add("DepartNow", (Object)this.departNow()).add("DepartureTime", (Object)this.departureTime()).add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationOptions", (Object)this.destinationOptions()).add("IsolineGeometryFormat", (Object)this.isolineGeometryFormatAsString()).add("IsolineGranularity", (Object)this.isolineGranularity()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("OptimizeIsolineFor", (Object)this.optimizeIsolineForAsString()).add("OptimizeRoutingFor", (Object)this.optimizeRoutingForAsString()).add("Origin", (Object)(this.origin() == null ? null : "*** Sensitive Data Redacted ***")).add("OriginOptions", (Object)this.originOptions()).add("Thresholds", (Object)this.thresholds()).add("Traffic", (Object)this.traffic()).add("TravelMode", (Object)this.travelModeAsString()).add("TravelModeOptions", (Object)this.travelModeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Allow": {
                return Optional.ofNullable(clazz.cast(this.allow()));
            }
            case "ArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.arrivalTime()));
            }
            case "Avoid": {
                return Optional.ofNullable(clazz.cast(this.avoid()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationOptions": {
                return Optional.ofNullable(clazz.cast(this.destinationOptions()));
            }
            case "IsolineGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.isolineGeometryFormatAsString()));
            }
            case "IsolineGranularity": {
                return Optional.ofNullable(clazz.cast(this.isolineGranularity()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "OptimizeIsolineFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeIsolineForAsString()));
            }
            case "OptimizeRoutingFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeRoutingForAsString()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "OriginOptions": {
                return Optional.ofNullable(clazz.cast(this.originOptions()));
            }
            case "Thresholds": {
                return Optional.ofNullable(clazz.cast(this.thresholds()));
            }
            case "Traffic": {
                return Optional.ofNullable(clazz.cast(this.traffic()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TravelModeOptions": {
                return Optional.ofNullable(clazz.cast(this.travelModeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Allow", ALLOW_FIELD);
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("Avoid", AVOID_FIELD);
        map.put("DepartNow", DEPART_NOW_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationOptions", DESTINATION_OPTIONS_FIELD);
        map.put("IsolineGeometryFormat", ISOLINE_GEOMETRY_FORMAT_FIELD);
        map.put("IsolineGranularity", ISOLINE_GRANULARITY_FIELD);
        map.put("key", KEY_FIELD);
        map.put("OptimizeIsolineFor", OPTIMIZE_ISOLINE_FOR_FIELD);
        map.put("OptimizeRoutingFor", OPTIMIZE_ROUTING_FOR_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginOptions", ORIGIN_OPTIONS_FIELD);
        map.put("Thresholds", THRESHOLDS_FIELD);
        map.put("Traffic", TRAFFIC_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateIsolinesRequest, T> g) {
        return obj -> g.apply((CalculateIsolinesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesRequest.BuilderImpl
    implements Builder {
        private IsolineAllowOptions allow;
        private String arrivalTime;
        private IsolineAvoidanceOptions avoid;
        private Boolean departNow;
        private String departureTime;
        private List<Double> destination = DefaultSdkAutoConstructList.getInstance();
        private IsolineDestinationOptions destinationOptions;
        private String isolineGeometryFormat;
        private IsolineGranularityOptions isolineGranularity;
        private String key;
        private String optimizeIsolineFor;
        private String optimizeRoutingFor;
        private List<Double> origin = DefaultSdkAutoConstructList.getInstance();
        private IsolineOriginOptions originOptions;
        private IsolineThresholds thresholds;
        private IsolineTrafficOptions traffic;
        private String travelMode;
        private IsolineTravelModeOptions travelModeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateIsolinesRequest model) {
            super(model);
            this.allow(model.allow);
            this.arrivalTime(model.arrivalTime);
            this.avoid(model.avoid);
            this.departNow(model.departNow);
            this.departureTime(model.departureTime);
            this.destination(model.destination);
            this.destinationOptions(model.destinationOptions);
            this.isolineGeometryFormat(model.isolineGeometryFormat);
            this.isolineGranularity(model.isolineGranularity);
            this.key(model.key);
            this.optimizeIsolineFor(model.optimizeIsolineFor);
            this.optimizeRoutingFor(model.optimizeRoutingFor);
            this.origin(model.origin);
            this.originOptions(model.originOptions);
            this.thresholds(model.thresholds);
            this.traffic(model.traffic);
            this.travelMode(model.travelMode);
            this.travelModeOptions(model.travelModeOptions);
        }

        public final IsolineAllowOptions.Builder getAllow() {
            return this.allow != null ? this.allow.toBuilder() : null;
        }

        public final void setAllow(IsolineAllowOptions.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(IsolineAllowOptions allow) {
            this.allow = allow;
            return this;
        }

        public final String getArrivalTime() {
            return this.arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final IsolineAvoidanceOptions.Builder getAvoid() {
            return this.avoid != null ? this.avoid.toBuilder() : null;
        }

        public final void setAvoid(IsolineAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(IsolineAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestination() {
            if (this.destination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destination;
        }

        public final void setDestination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Double ... destination) {
            this.destination(Arrays.asList(destination));
            return this;
        }

        public final IsolineDestinationOptions.Builder getDestinationOptions() {
            return this.destinationOptions != null ? this.destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(IsolineDestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(IsolineDestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final String getIsolineGeometryFormat() {
            return this.isolineGeometryFormat;
        }

        public final void setIsolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
        }

        @Override
        public final Builder isolineGeometryFormat(String isolineGeometryFormat) {
            this.isolineGeometryFormat = isolineGeometryFormat;
            return this;
        }

        @Override
        public final Builder isolineGeometryFormat(GeometryFormat isolineGeometryFormat) {
            this.isolineGeometryFormat(isolineGeometryFormat == null ? null : isolineGeometryFormat.toString());
            return this;
        }

        public final IsolineGranularityOptions.Builder getIsolineGranularity() {
            return this.isolineGranularity != null ? this.isolineGranularity.toBuilder() : null;
        }

        public final void setIsolineGranularity(IsolineGranularityOptions.BuilderImpl isolineGranularity) {
            this.isolineGranularity = isolineGranularity != null ? isolineGranularity.build() : null;
        }

        @Override
        public final Builder isolineGranularity(IsolineGranularityOptions isolineGranularity) {
            this.isolineGranularity = isolineGranularity;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getOptimizeIsolineFor() {
            return this.optimizeIsolineFor;
        }

        public final void setOptimizeIsolineFor(String optimizeIsolineFor) {
            this.optimizeIsolineFor = optimizeIsolineFor;
        }

        @Override
        public final Builder optimizeIsolineFor(String optimizeIsolineFor) {
            this.optimizeIsolineFor = optimizeIsolineFor;
            return this;
        }

        @Override
        public final Builder optimizeIsolineFor(IsolineOptimizationObjective optimizeIsolineFor) {
            this.optimizeIsolineFor(optimizeIsolineFor == null ? null : optimizeIsolineFor.toString());
            return this;
        }

        public final String getOptimizeRoutingFor() {
            return this.optimizeRoutingFor;
        }

        public final void setOptimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
        }

        @Override
        public final Builder optimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
            return this;
        }

        @Override
        public final Builder optimizeRoutingFor(RoutingObjective optimizeRoutingFor) {
            this.optimizeRoutingFor(optimizeRoutingFor == null ? null : optimizeRoutingFor.toString());
            return this;
        }

        public final Collection<Double> getOrigin() {
            if (this.origin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.origin;
        }

        public final void setOrigin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
        }

        @Override
        public final Builder origin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origin(Double ... origin) {
            this.origin(Arrays.asList(origin));
            return this;
        }

        public final IsolineOriginOptions.Builder getOriginOptions() {
            return this.originOptions != null ? this.originOptions.toBuilder() : null;
        }

        public final void setOriginOptions(IsolineOriginOptions.BuilderImpl originOptions) {
            this.originOptions = originOptions != null ? originOptions.build() : null;
        }

        @Override
        public final Builder originOptions(IsolineOriginOptions originOptions) {
            this.originOptions = originOptions;
            return this;
        }

        public final IsolineThresholds.Builder getThresholds() {
            return this.thresholds != null ? this.thresholds.toBuilder() : null;
        }

        public final void setThresholds(IsolineThresholds.BuilderImpl thresholds) {
            this.thresholds = thresholds != null ? thresholds.build() : null;
        }

        @Override
        public final Builder thresholds(IsolineThresholds thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public final IsolineTrafficOptions.Builder getTraffic() {
            return this.traffic != null ? this.traffic.toBuilder() : null;
        }

        public final void setTraffic(IsolineTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(IsolineTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(IsolineTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final IsolineTravelModeOptions.Builder getTravelModeOptions() {
            return this.travelModeOptions != null ? this.travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(IsolineTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(IsolineTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateIsolinesRequest build() {
            return new CalculateIsolinesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoRoutesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateIsolinesRequest> {
        public Builder allow(IsolineAllowOptions var1);

        default public Builder allow(Consumer<IsolineAllowOptions.Builder> allow) {
            return this.allow((IsolineAllowOptions)((IsolineAllowOptions.Builder)IsolineAllowOptions.builder().applyMutation(allow)).build());
        }

        public Builder arrivalTime(String var1);

        public Builder avoid(IsolineAvoidanceOptions var1);

        default public Builder avoid(Consumer<IsolineAvoidanceOptions.Builder> avoid) {
            return this.avoid((IsolineAvoidanceOptions)((IsolineAvoidanceOptions.Builder)IsolineAvoidanceOptions.builder().applyMutation(avoid)).build());
        }

        public Builder departNow(Boolean var1);

        public Builder departureTime(String var1);

        public Builder destination(Collection<Double> var1);

        public Builder destination(Double ... var1);

        public Builder destinationOptions(IsolineDestinationOptions var1);

        default public Builder destinationOptions(Consumer<IsolineDestinationOptions.Builder> destinationOptions) {
            return this.destinationOptions((IsolineDestinationOptions)((IsolineDestinationOptions.Builder)IsolineDestinationOptions.builder().applyMutation(destinationOptions)).build());
        }

        public Builder isolineGeometryFormat(String var1);

        public Builder isolineGeometryFormat(GeometryFormat var1);

        public Builder isolineGranularity(IsolineGranularityOptions var1);

        default public Builder isolineGranularity(Consumer<IsolineGranularityOptions.Builder> isolineGranularity) {
            return this.isolineGranularity((IsolineGranularityOptions)((IsolineGranularityOptions.Builder)IsolineGranularityOptions.builder().applyMutation(isolineGranularity)).build());
        }

        public Builder key(String var1);

        public Builder optimizeIsolineFor(String var1);

        public Builder optimizeIsolineFor(IsolineOptimizationObjective var1);

        public Builder optimizeRoutingFor(String var1);

        public Builder optimizeRoutingFor(RoutingObjective var1);

        public Builder origin(Collection<Double> var1);

        public Builder origin(Double ... var1);

        public Builder originOptions(IsolineOriginOptions var1);

        default public Builder originOptions(Consumer<IsolineOriginOptions.Builder> originOptions) {
            return this.originOptions((IsolineOriginOptions)((IsolineOriginOptions.Builder)IsolineOriginOptions.builder().applyMutation(originOptions)).build());
        }

        public Builder thresholds(IsolineThresholds var1);

        default public Builder thresholds(Consumer<IsolineThresholds.Builder> thresholds) {
            return this.thresholds((IsolineThresholds)((IsolineThresholds.Builder)IsolineThresholds.builder().applyMutation(thresholds)).build());
        }

        public Builder traffic(IsolineTrafficOptions var1);

        default public Builder traffic(Consumer<IsolineTrafficOptions.Builder> traffic) {
            return this.traffic((IsolineTrafficOptions)((IsolineTrafficOptions.Builder)IsolineTrafficOptions.builder().applyMutation(traffic)).build());
        }

        public Builder travelMode(String var1);

        public Builder travelMode(IsolineTravelMode var1);

        public Builder travelModeOptions(IsolineTravelModeOptions var1);

        default public Builder travelModeOptions(Consumer<IsolineTravelModeOptions.Builder> travelModeOptions) {
            return this.travelModeOptions((IsolineTravelModeOptions)((IsolineTravelModeOptions.Builder)IsolineTravelModeOptions.builder().applyMutation(travelModeOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

