/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.IndexListCopier;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteNumber;
import software.amazon.awssdk.services.georoutes.model.RouteNumberListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanCarAccessAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanCarAccessAttributeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanDynamicSpeedDetails;
import software.amazon.awssdk.services.georoutes.model.RouteSpanGateAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanRailwayCrossingAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanRoadAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanRoadAttributeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanScooterAccessAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanScooterAccessAttributeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanSpeedLimitDetails;
import software.amazon.awssdk.services.georoutes.model.RouteSpanTruckAccessAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanTruckAccessAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteVehicleSpan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteVehicleSpan> {
    private static final SdkField<Long> BEST_CASE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BestCaseDuration").getter(RouteVehicleSpan.getter(RouteVehicleSpan::bestCaseDuration)).setter(RouteVehicleSpan.setter(Builder::bestCaseDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseDuration").build()}).build();
    private static final SdkField<List<String>> CAR_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CarAccess").getter(RouteVehicleSpan.getter(RouteVehicleSpan::carAccessAsStrings)).setter(RouteVehicleSpan.setter(Builder::carAccessWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(RouteVehicleSpan.getter(RouteVehicleSpan::country)).setter(RouteVehicleSpan.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RouteVehicleSpan.getter(RouteVehicleSpan::distance)).setter(RouteVehicleSpan.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RouteVehicleSpan.getter(RouteVehicleSpan::duration)).setter(RouteVehicleSpan.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<RouteSpanDynamicSpeedDetails> DYNAMIC_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicSpeed").getter(RouteVehicleSpan.getter(RouteVehicleSpan::dynamicSpeed)).setter(RouteVehicleSpan.setter(Builder::dynamicSpeed)).constructor(RouteSpanDynamicSpeedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicSpeed").build()}).build();
    private static final SdkField<Integer> FUNCTIONAL_CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FunctionalClassification").getter(RouteVehicleSpan.getter(RouteVehicleSpan::functionalClassification)).setter(RouteVehicleSpan.setter(Builder::functionalClassification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionalClassification").build()}).build();
    private static final SdkField<String> GATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gate").getter(RouteVehicleSpan.getter(RouteVehicleSpan::gateAsString)).setter(RouteVehicleSpan.setter(Builder::gate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gate").build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(RouteVehicleSpan.getter(RouteVehicleSpan::geometryOffset)).setter(RouteVehicleSpan.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<List<Integer>> INCIDENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Incidents").getter(RouteVehicleSpan.getter(RouteVehicleSpan::incidents)).setter(RouteVehicleSpan.setter(Builder::incidents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Incidents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalizedString>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(RouteVehicleSpan.getter(RouteVehicleSpan::names)).setter(RouteVehicleSpan.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> NOTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notices").getter(RouteVehicleSpan.getter(RouteVehicleSpan::notices)).setter(RouteVehicleSpan.setter(Builder::notices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RAILWAY_CROSSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RailwayCrossing").getter(RouteVehicleSpan.getter(RouteVehicleSpan::railwayCrossingAsString)).setter(RouteVehicleSpan.setter(Builder::railwayCrossing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RailwayCrossing").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RouteVehicleSpan.getter(RouteVehicleSpan::region)).setter(RouteVehicleSpan.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<List<String>> ROAD_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoadAttributes").getter(RouteVehicleSpan.getter(RouteVehicleSpan::roadAttributesAsStrings)).setter(RouteVehicleSpan.setter(Builder::roadAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteNumber>> ROUTE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteNumbers").getter(RouteVehicleSpan.getter(RouteVehicleSpan::routeNumbers)).setter(RouteVehicleSpan.setter(Builder::routeNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SCOOTER_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScooterAccess").getter(RouteVehicleSpan.getter(RouteVehicleSpan::scooterAccessAsStrings)).setter(RouteVehicleSpan.setter(Builder::scooterAccessWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScooterAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteSpanSpeedLimitDetails> SPEED_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpeedLimit").getter(RouteVehicleSpan.getter(RouteVehicleSpan::speedLimit)).setter(RouteVehicleSpan.setter(Builder::speedLimit)).constructor(RouteSpanSpeedLimitDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedLimit").build()}).build();
    private static final SdkField<List<Integer>> TOLL_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TollSystems").getter(RouteVehicleSpan.getter(RouteVehicleSpan::tollSystems)).setter(RouteVehicleSpan.setter(Builder::tollSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRUCK_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruckAccess").getter(RouteVehicleSpan.getter(RouteVehicleSpan::truckAccessAsStrings)).setter(RouteVehicleSpan.setter(Builder::truckAccessWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> TRUCK_ROAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruckRoadTypes").getter(RouteVehicleSpan.getter(RouteVehicleSpan::truckRoadTypes)).setter(RouteVehicleSpan.setter(Builder::truckRoadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TYPICAL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TypicalDuration").getter(RouteVehicleSpan.getter(RouteVehicleSpan::typicalDuration)).setter(RouteVehicleSpan.setter(Builder::typicalDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalDuration").build()}).build();
    private static final SdkField<List<Integer>> ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Zones").getter(RouteVehicleSpan.getter(RouteVehicleSpan::zones)).setter(RouteVehicleSpan.setter(Builder::zones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_DURATION_FIELD, CAR_ACCESS_FIELD, COUNTRY_FIELD, DISTANCE_FIELD, DURATION_FIELD, DYNAMIC_SPEED_FIELD, FUNCTIONAL_CLASSIFICATION_FIELD, GATE_FIELD, GEOMETRY_OFFSET_FIELD, INCIDENTS_FIELD, NAMES_FIELD, NOTICES_FIELD, RAILWAY_CROSSING_FIELD, REGION_FIELD, ROAD_ATTRIBUTES_FIELD, ROUTE_NUMBERS_FIELD, SCOOTER_ACCESS_FIELD, SPEED_LIMIT_FIELD, TOLL_SYSTEMS_FIELD, TRUCK_ACCESS_FIELD, TRUCK_ROAD_TYPES_FIELD, TYPICAL_DURATION_FIELD, ZONES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteVehicleSpan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long bestCaseDuration;
    private final List<String> carAccess;
    private final String country;
    private final Long distance;
    private final Long duration;
    private final RouteSpanDynamicSpeedDetails dynamicSpeed;
    private final Integer functionalClassification;
    private final String gate;
    private final Integer geometryOffset;
    private final List<Integer> incidents;
    private final List<LocalizedString> names;
    private final List<Integer> notices;
    private final String railwayCrossing;
    private final String region;
    private final List<String> roadAttributes;
    private final List<RouteNumber> routeNumbers;
    private final List<String> scooterAccess;
    private final RouteSpanSpeedLimitDetails speedLimit;
    private final List<Integer> tollSystems;
    private final List<String> truckAccess;
    private final List<Integer> truckRoadTypes;
    private final Long typicalDuration;
    private final List<Integer> zones;

    private RouteVehicleSpan(BuilderImpl builder) {
        this.bestCaseDuration = builder.bestCaseDuration;
        this.carAccess = builder.carAccess;
        this.country = builder.country;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.dynamicSpeed = builder.dynamicSpeed;
        this.functionalClassification = builder.functionalClassification;
        this.gate = builder.gate;
        this.geometryOffset = builder.geometryOffset;
        this.incidents = builder.incidents;
        this.names = builder.names;
        this.notices = builder.notices;
        this.railwayCrossing = builder.railwayCrossing;
        this.region = builder.region;
        this.roadAttributes = builder.roadAttributes;
        this.routeNumbers = builder.routeNumbers;
        this.scooterAccess = builder.scooterAccess;
        this.speedLimit = builder.speedLimit;
        this.tollSystems = builder.tollSystems;
        this.truckAccess = builder.truckAccess;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.typicalDuration = builder.typicalDuration;
        this.zones = builder.zones;
    }

    public final Long bestCaseDuration() {
        return this.bestCaseDuration;
    }

    public final List<RouteSpanCarAccessAttribute> carAccess() {
        return RouteSpanCarAccessAttributeListCopier.copyStringToEnum(this.carAccess);
    }

    public final boolean hasCarAccess() {
        return this.carAccess != null && !(this.carAccess instanceof SdkAutoConstructList);
    }

    public final List<String> carAccessAsStrings() {
        return this.carAccess;
    }

    public final String country() {
        return this.country;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final RouteSpanDynamicSpeedDetails dynamicSpeed() {
        return this.dynamicSpeed;
    }

    public final Integer functionalClassification() {
        return this.functionalClassification;
    }

    public final RouteSpanGateAttribute gate() {
        return RouteSpanGateAttribute.fromValue(this.gate);
    }

    public final String gateAsString() {
        return this.gate;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final boolean hasIncidents() {
        return this.incidents != null && !(this.incidents instanceof SdkAutoConstructList);
    }

    public final List<Integer> incidents() {
        return this.incidents;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> names() {
        return this.names;
    }

    public final boolean hasNotices() {
        return this.notices != null && !(this.notices instanceof SdkAutoConstructList);
    }

    public final List<Integer> notices() {
        return this.notices;
    }

    public final RouteSpanRailwayCrossingAttribute railwayCrossing() {
        return RouteSpanRailwayCrossingAttribute.fromValue(this.railwayCrossing);
    }

    public final String railwayCrossingAsString() {
        return this.railwayCrossing;
    }

    public final String region() {
        return this.region;
    }

    public final List<RouteSpanRoadAttribute> roadAttributes() {
        return RouteSpanRoadAttributeListCopier.copyStringToEnum(this.roadAttributes);
    }

    public final boolean hasRoadAttributes() {
        return this.roadAttributes != null && !(this.roadAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> roadAttributesAsStrings() {
        return this.roadAttributes;
    }

    public final boolean hasRouteNumbers() {
        return this.routeNumbers != null && !(this.routeNumbers instanceof SdkAutoConstructList);
    }

    public final List<RouteNumber> routeNumbers() {
        return this.routeNumbers;
    }

    public final List<RouteSpanScooterAccessAttribute> scooterAccess() {
        return RouteSpanScooterAccessAttributeListCopier.copyStringToEnum(this.scooterAccess);
    }

    public final boolean hasScooterAccess() {
        return this.scooterAccess != null && !(this.scooterAccess instanceof SdkAutoConstructList);
    }

    public final List<String> scooterAccessAsStrings() {
        return this.scooterAccess;
    }

    public final RouteSpanSpeedLimitDetails speedLimit() {
        return this.speedLimit;
    }

    public final boolean hasTollSystems() {
        return this.tollSystems != null && !(this.tollSystems instanceof SdkAutoConstructList);
    }

    public final List<Integer> tollSystems() {
        return this.tollSystems;
    }

    public final List<RouteSpanTruckAccessAttribute> truckAccess() {
        return RouteSpanTruckAccessAttributeListCopier.copyStringToEnum(this.truckAccess);
    }

    public final boolean hasTruckAccess() {
        return this.truckAccess != null && !(this.truckAccess instanceof SdkAutoConstructList);
    }

    public final List<String> truckAccessAsStrings() {
        return this.truckAccess;
    }

    public final boolean hasTruckRoadTypes() {
        return this.truckRoadTypes != null && !(this.truckRoadTypes instanceof SdkAutoConstructList);
    }

    public final List<Integer> truckRoadTypes() {
        return this.truckRoadTypes;
    }

    public final Long typicalDuration() {
        return this.typicalDuration;
    }

    public final boolean hasZones() {
        return this.zones != null && !(this.zones instanceof SdkAutoConstructList);
    }

    public final List<Integer> zones() {
        return this.zones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bestCaseDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCarAccess() ? this.carAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionalClassification());
        hashCode = 31 * hashCode + Objects.hashCode(this.gateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidents() ? this.incidents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotices() ? this.notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.railwayCrossingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoadAttributes() ? this.roadAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteNumbers() ? this.routeNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScooterAccess() ? this.scooterAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.speedLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTollSystems() ? this.tollSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruckAccess() ? this.truckAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruckRoadTypes() ? this.truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typicalDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasZones() ? this.zones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleSpan)) {
            return false;
        }
        RouteVehicleSpan other = (RouteVehicleSpan)obj;
        return Objects.equals(this.bestCaseDuration(), other.bestCaseDuration()) && this.hasCarAccess() == other.hasCarAccess() && Objects.equals(this.carAccessAsStrings(), other.carAccessAsStrings()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.dynamicSpeed(), other.dynamicSpeed()) && Objects.equals(this.functionalClassification(), other.functionalClassification()) && Objects.equals(this.gateAsString(), other.gateAsString()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && this.hasIncidents() == other.hasIncidents() && Objects.equals(this.incidents(), other.incidents()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasNotices() == other.hasNotices() && Objects.equals(this.notices(), other.notices()) && Objects.equals(this.railwayCrossingAsString(), other.railwayCrossingAsString()) && Objects.equals(this.region(), other.region()) && this.hasRoadAttributes() == other.hasRoadAttributes() && Objects.equals(this.roadAttributesAsStrings(), other.roadAttributesAsStrings()) && this.hasRouteNumbers() == other.hasRouteNumbers() && Objects.equals(this.routeNumbers(), other.routeNumbers()) && this.hasScooterAccess() == other.hasScooterAccess() && Objects.equals(this.scooterAccessAsStrings(), other.scooterAccessAsStrings()) && Objects.equals(this.speedLimit(), other.speedLimit()) && this.hasTollSystems() == other.hasTollSystems() && Objects.equals(this.tollSystems(), other.tollSystems()) && this.hasTruckAccess() == other.hasTruckAccess() && Objects.equals(this.truckAccessAsStrings(), other.truckAccessAsStrings()) && this.hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(this.truckRoadTypes(), other.truckRoadTypes()) && Objects.equals(this.typicalDuration(), other.typicalDuration()) && this.hasZones() == other.hasZones() && Objects.equals(this.zones(), other.zones());
    }

    public final String toString() {
        return ToString.builder((String)"RouteVehicleSpan").add("BestCaseDuration", (Object)this.bestCaseDuration()).add("CarAccess", this.hasCarAccess() ? this.carAccessAsStrings() : null).add("Country", (Object)this.country()).add("Distance", (Object)this.distance()).add("Duration", (Object)this.duration()).add("DynamicSpeed", (Object)this.dynamicSpeed()).add("FunctionalClassification", (Object)this.functionalClassification()).add("Gate", (Object)this.gateAsString()).add("GeometryOffset", (Object)this.geometryOffset()).add("Incidents", this.hasIncidents() ? this.incidents() : null).add("Names", this.hasNames() ? this.names() : null).add("Notices", this.hasNotices() ? this.notices() : null).add("RailwayCrossing", (Object)this.railwayCrossingAsString()).add("Region", (Object)this.region()).add("RoadAttributes", this.hasRoadAttributes() ? this.roadAttributesAsStrings() : null).add("RouteNumbers", this.hasRouteNumbers() ? this.routeNumbers() : null).add("ScooterAccess", this.hasScooterAccess() ? this.scooterAccessAsStrings() : null).add("SpeedLimit", (Object)this.speedLimit()).add("TollSystems", this.hasTollSystems() ? this.tollSystems() : null).add("TruckAccess", this.hasTruckAccess() ? this.truckAccessAsStrings() : null).add("TruckRoadTypes", this.hasTruckRoadTypes() ? this.truckRoadTypes() : null).add("TypicalDuration", (Object)this.typicalDuration()).add("Zones", this.hasZones() ? this.zones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BestCaseDuration": {
                return Optional.ofNullable(clazz.cast(this.bestCaseDuration()));
            }
            case "CarAccess": {
                return Optional.ofNullable(clazz.cast(this.carAccessAsStrings()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DynamicSpeed": {
                return Optional.ofNullable(clazz.cast(this.dynamicSpeed()));
            }
            case "FunctionalClassification": {
                return Optional.ofNullable(clazz.cast(this.functionalClassification()));
            }
            case "Gate": {
                return Optional.ofNullable(clazz.cast(this.gateAsString()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "Incidents": {
                return Optional.ofNullable(clazz.cast(this.incidents()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Notices": {
                return Optional.ofNullable(clazz.cast(this.notices()));
            }
            case "RailwayCrossing": {
                return Optional.ofNullable(clazz.cast(this.railwayCrossingAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "RoadAttributes": {
                return Optional.ofNullable(clazz.cast(this.roadAttributesAsStrings()));
            }
            case "RouteNumbers": {
                return Optional.ofNullable(clazz.cast(this.routeNumbers()));
            }
            case "ScooterAccess": {
                return Optional.ofNullable(clazz.cast(this.scooterAccessAsStrings()));
            }
            case "SpeedLimit": {
                return Optional.ofNullable(clazz.cast(this.speedLimit()));
            }
            case "TollSystems": {
                return Optional.ofNullable(clazz.cast(this.tollSystems()));
            }
            case "TruckAccess": {
                return Optional.ofNullable(clazz.cast(this.truckAccessAsStrings()));
            }
            case "TruckRoadTypes": {
                return Optional.ofNullable(clazz.cast(this.truckRoadTypes()));
            }
            case "TypicalDuration": {
                return Optional.ofNullable(clazz.cast(this.typicalDuration()));
            }
            case "Zones": {
                return Optional.ofNullable(clazz.cast(this.zones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BestCaseDuration", BEST_CASE_DURATION_FIELD);
        map.put("CarAccess", CAR_ACCESS_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("DynamicSpeed", DYNAMIC_SPEED_FIELD);
        map.put("FunctionalClassification", FUNCTIONAL_CLASSIFICATION_FIELD);
        map.put("Gate", GATE_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Incidents", INCIDENTS_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("RailwayCrossing", RAILWAY_CROSSING_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("RoadAttributes", ROAD_ATTRIBUTES_FIELD);
        map.put("RouteNumbers", ROUTE_NUMBERS_FIELD);
        map.put("ScooterAccess", SCOOTER_ACCESS_FIELD);
        map.put("SpeedLimit", SPEED_LIMIT_FIELD);
        map.put("TollSystems", TOLL_SYSTEMS_FIELD);
        map.put("TruckAccess", TRUCK_ACCESS_FIELD);
        map.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
        map.put("TypicalDuration", TYPICAL_DURATION_FIELD);
        map.put("Zones", ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleSpan, T> g) {
        return obj -> g.apply((RouteVehicleSpan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bestCaseDuration;
        private List<String> carAccess = DefaultSdkAutoConstructList.getInstance();
        private String country;
        private Long distance;
        private Long duration;
        private RouteSpanDynamicSpeedDetails dynamicSpeed;
        private Integer functionalClassification;
        private String gate;
        private Integer geometryOffset;
        private List<Integer> incidents = DefaultSdkAutoConstructList.getInstance();
        private List<LocalizedString> names = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> notices = DefaultSdkAutoConstructList.getInstance();
        private String railwayCrossing;
        private String region;
        private List<String> roadAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<RouteNumber> routeNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<String> scooterAccess = DefaultSdkAutoConstructList.getInstance();
        private RouteSpanSpeedLimitDetails speedLimit;
        private List<Integer> tollSystems = DefaultSdkAutoConstructList.getInstance();
        private List<String> truckAccess = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();
        private Long typicalDuration;
        private List<Integer> zones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleSpan model) {
            this.bestCaseDuration(model.bestCaseDuration);
            this.carAccessWithStrings(model.carAccess);
            this.country(model.country);
            this.distance(model.distance);
            this.duration(model.duration);
            this.dynamicSpeed(model.dynamicSpeed);
            this.functionalClassification(model.functionalClassification);
            this.gate(model.gate);
            this.geometryOffset(model.geometryOffset);
            this.incidents(model.incidents);
            this.names(model.names);
            this.notices(model.notices);
            this.railwayCrossing(model.railwayCrossing);
            this.region(model.region);
            this.roadAttributesWithStrings(model.roadAttributes);
            this.routeNumbers(model.routeNumbers);
            this.scooterAccessWithStrings(model.scooterAccess);
            this.speedLimit(model.speedLimit);
            this.tollSystems(model.tollSystems);
            this.truckAccessWithStrings(model.truckAccess);
            this.truckRoadTypes(model.truckRoadTypes);
            this.typicalDuration(model.typicalDuration);
            this.zones(model.zones);
        }

        public final Long getBestCaseDuration() {
            return this.bestCaseDuration;
        }

        public final void setBestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
        }

        @Override
        public final Builder bestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
            return this;
        }

        public final Collection<String> getCarAccess() {
            if (this.carAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.carAccess;
        }

        public final void setCarAccess(Collection<String> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copy(carAccess);
        }

        @Override
        public final Builder carAccessWithStrings(Collection<String> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copy(carAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carAccessWithStrings(String ... carAccess) {
            this.carAccessWithStrings(Arrays.asList(carAccess));
            return this;
        }

        @Override
        public final Builder carAccess(Collection<RouteSpanCarAccessAttribute> carAccess) {
            this.carAccess = RouteSpanCarAccessAttributeListCopier.copyEnumToString(carAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carAccess(RouteSpanCarAccessAttribute ... carAccess) {
            this.carAccess(Arrays.asList(carAccess));
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final RouteSpanDynamicSpeedDetails.Builder getDynamicSpeed() {
            return this.dynamicSpeed != null ? this.dynamicSpeed.toBuilder() : null;
        }

        public final void setDynamicSpeed(RouteSpanDynamicSpeedDetails.BuilderImpl dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed != null ? dynamicSpeed.build() : null;
        }

        @Override
        public final Builder dynamicSpeed(RouteSpanDynamicSpeedDetails dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed;
            return this;
        }

        public final Integer getFunctionalClassification() {
            return this.functionalClassification;
        }

        public final void setFunctionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
        }

        @Override
        public final Builder functionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
            return this;
        }

        public final String getGate() {
            return this.gate;
        }

        public final void setGate(String gate) {
            this.gate = gate;
        }

        @Override
        public final Builder gate(String gate) {
            this.gate = gate;
            return this;
        }

        @Override
        public final Builder gate(RouteSpanGateAttribute gate) {
            this.gate(gate == null ? null : gate.toString());
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final Collection<Integer> getIncidents() {
            if (this.incidents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.incidents;
        }

        public final void setIncidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
        }

        @Override
        public final Builder incidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(Integer ... incidents) {
            this.incidents(Arrays.asList(incidents));
            return this;
        }

        public final List<LocalizedString.Builder> getNames() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<LocalizedString.BuilderImpl> names) {
            this.names = LocalizedStringListCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<LocalizedString> names) {
            this.names = LocalizedStringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(LocalizedString ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<LocalizedString.Builder> ... names) {
            this.names(Stream.of(names).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getNotices() {
            if (this.notices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notices;
        }

        public final void setNotices(Collection<Integer> notices) {
            this.notices = IndexListCopier.copy(notices);
        }

        @Override
        public final Builder notices(Collection<Integer> notices) {
            this.notices = IndexListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Integer ... notices) {
            this.notices(Arrays.asList(notices));
            return this;
        }

        public final String getRailwayCrossing() {
            return this.railwayCrossing;
        }

        public final void setRailwayCrossing(String railwayCrossing) {
            this.railwayCrossing = railwayCrossing;
        }

        @Override
        public final Builder railwayCrossing(String railwayCrossing) {
            this.railwayCrossing = railwayCrossing;
            return this;
        }

        @Override
        public final Builder railwayCrossing(RouteSpanRailwayCrossingAttribute railwayCrossing) {
            this.railwayCrossing(railwayCrossing == null ? null : railwayCrossing.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getRoadAttributes() {
            if (this.roadAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roadAttributes;
        }

        public final void setRoadAttributes(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
        }

        @Override
        public final Builder roadAttributesWithStrings(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributesWithStrings(String ... roadAttributes) {
            this.roadAttributesWithStrings(Arrays.asList(roadAttributes));
            return this;
        }

        @Override
        public final Builder roadAttributes(Collection<RouteSpanRoadAttribute> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copyEnumToString(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributes(RouteSpanRoadAttribute ... roadAttributes) {
            this.roadAttributes(Arrays.asList(roadAttributes));
            return this;
        }

        public final List<RouteNumber.Builder> getRouteNumbers() {
            List<RouteNumber.Builder> result = RouteNumberListCopier.copyToBuilder(this.routeNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteNumbers(Collection<RouteNumber.BuilderImpl> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copyFromBuilder(routeNumbers);
        }

        @Override
        public final Builder routeNumbers(Collection<RouteNumber> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copy(routeNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(RouteNumber ... routeNumbers) {
            this.routeNumbers(Arrays.asList(routeNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(Consumer<RouteNumber.Builder> ... routeNumbers) {
            this.routeNumbers(Stream.of(routeNumbers).map(c -> (RouteNumber)((RouteNumber.Builder)RouteNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getScooterAccess() {
            if (this.scooterAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scooterAccess;
        }

        public final void setScooterAccess(Collection<String> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copy(scooterAccess);
        }

        @Override
        public final Builder scooterAccessWithStrings(Collection<String> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copy(scooterAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scooterAccessWithStrings(String ... scooterAccess) {
            this.scooterAccessWithStrings(Arrays.asList(scooterAccess));
            return this;
        }

        @Override
        public final Builder scooterAccess(Collection<RouteSpanScooterAccessAttribute> scooterAccess) {
            this.scooterAccess = RouteSpanScooterAccessAttributeListCopier.copyEnumToString(scooterAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scooterAccess(RouteSpanScooterAccessAttribute ... scooterAccess) {
            this.scooterAccess(Arrays.asList(scooterAccess));
            return this;
        }

        public final RouteSpanSpeedLimitDetails.Builder getSpeedLimit() {
            return this.speedLimit != null ? this.speedLimit.toBuilder() : null;
        }

        public final void setSpeedLimit(RouteSpanSpeedLimitDetails.BuilderImpl speedLimit) {
            this.speedLimit = speedLimit != null ? speedLimit.build() : null;
        }

        @Override
        public final Builder speedLimit(RouteSpanSpeedLimitDetails speedLimit) {
            this.speedLimit = speedLimit;
            return this;
        }

        public final Collection<Integer> getTollSystems() {
            if (this.tollSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tollSystems;
        }

        public final void setTollSystems(Collection<Integer> tollSystems) {
            this.tollSystems = IndexListCopier.copy(tollSystems);
        }

        @Override
        public final Builder tollSystems(Collection<Integer> tollSystems) {
            this.tollSystems = IndexListCopier.copy(tollSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(Integer ... tollSystems) {
            this.tollSystems(Arrays.asList(tollSystems));
            return this;
        }

        public final Collection<String> getTruckAccess() {
            if (this.truckAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truckAccess;
        }

        public final void setTruckAccess(Collection<String> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copy(truckAccess);
        }

        @Override
        public final Builder truckAccessWithStrings(Collection<String> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copy(truckAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckAccessWithStrings(String ... truckAccess) {
            this.truckAccessWithStrings(Arrays.asList(truckAccess));
            return this;
        }

        @Override
        public final Builder truckAccess(Collection<RouteSpanTruckAccessAttribute> truckAccess) {
            this.truckAccess = RouteSpanTruckAccessAttributeListCopier.copyEnumToString(truckAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckAccess(RouteSpanTruckAccessAttribute ... truckAccess) {
            this.truckAccess(Arrays.asList(truckAccess));
            return this;
        }

        public final Collection<Integer> getTruckRoadTypes() {
            if (this.truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<Integer> truckRoadTypes) {
            this.truckRoadTypes = IndexListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<Integer> truckRoadTypes) {
            this.truckRoadTypes = IndexListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(Integer ... truckRoadTypes) {
            this.truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final Long getTypicalDuration() {
            return this.typicalDuration;
        }

        public final void setTypicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
        }

        @Override
        public final Builder typicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
            return this;
        }

        public final Collection<Integer> getZones() {
            if (this.zones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.zones;
        }

        public final void setZones(Collection<Integer> zones) {
            this.zones = IndexListCopier.copy(zones);
        }

        @Override
        public final Builder zones(Collection<Integer> zones) {
            this.zones = IndexListCopier.copy(zones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(Integer ... zones) {
            this.zones(Arrays.asList(zones));
            return this;
        }

        public RouteVehicleSpan build() {
            return new RouteVehicleSpan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteVehicleSpan> {
        public Builder bestCaseDuration(Long var1);

        public Builder carAccessWithStrings(Collection<String> var1);

        public Builder carAccessWithStrings(String ... var1);

        public Builder carAccess(Collection<RouteSpanCarAccessAttribute> var1);

        public Builder carAccess(RouteSpanCarAccessAttribute ... var1);

        public Builder country(String var1);

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder dynamicSpeed(RouteSpanDynamicSpeedDetails var1);

        default public Builder dynamicSpeed(Consumer<RouteSpanDynamicSpeedDetails.Builder> dynamicSpeed) {
            return this.dynamicSpeed((RouteSpanDynamicSpeedDetails)((RouteSpanDynamicSpeedDetails.Builder)RouteSpanDynamicSpeedDetails.builder().applyMutation(dynamicSpeed)).build());
        }

        public Builder functionalClassification(Integer var1);

        public Builder gate(String var1);

        public Builder gate(RouteSpanGateAttribute var1);

        public Builder geometryOffset(Integer var1);

        public Builder incidents(Collection<Integer> var1);

        public Builder incidents(Integer ... var1);

        public Builder names(Collection<LocalizedString> var1);

        public Builder names(LocalizedString ... var1);

        public Builder names(Consumer<LocalizedString.Builder> ... var1);

        public Builder notices(Collection<Integer> var1);

        public Builder notices(Integer ... var1);

        public Builder railwayCrossing(String var1);

        public Builder railwayCrossing(RouteSpanRailwayCrossingAttribute var1);

        public Builder region(String var1);

        public Builder roadAttributesWithStrings(Collection<String> var1);

        public Builder roadAttributesWithStrings(String ... var1);

        public Builder roadAttributes(Collection<RouteSpanRoadAttribute> var1);

        public Builder roadAttributes(RouteSpanRoadAttribute ... var1);

        public Builder routeNumbers(Collection<RouteNumber> var1);

        public Builder routeNumbers(RouteNumber ... var1);

        public Builder routeNumbers(Consumer<RouteNumber.Builder> ... var1);

        public Builder scooterAccessWithStrings(Collection<String> var1);

        public Builder scooterAccessWithStrings(String ... var1);

        public Builder scooterAccess(Collection<RouteSpanScooterAccessAttribute> var1);

        public Builder scooterAccess(RouteSpanScooterAccessAttribute ... var1);

        public Builder speedLimit(RouteSpanSpeedLimitDetails var1);

        default public Builder speedLimit(Consumer<RouteSpanSpeedLimitDetails.Builder> speedLimit) {
            return this.speedLimit((RouteSpanSpeedLimitDetails)((RouteSpanSpeedLimitDetails.Builder)RouteSpanSpeedLimitDetails.builder().applyMutation(speedLimit)).build());
        }

        public Builder tollSystems(Collection<Integer> var1);

        public Builder tollSystems(Integer ... var1);

        public Builder truckAccessWithStrings(Collection<String> var1);

        public Builder truckAccessWithStrings(String ... var1);

        public Builder truckAccess(Collection<RouteSpanTruckAccessAttribute> var1);

        public Builder truckAccess(RouteSpanTruckAccessAttribute ... var1);

        public Builder truckRoadTypes(Collection<Integer> var1);

        public Builder truckRoadTypes(Integer ... var1);

        public Builder typicalDuration(Long var1);

        public Builder zones(Collection<Integer> var1);

        public Builder zones(Integer ... var1);
    }
}

