/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.MatchingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixMatchingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixMatchingOptions> {
    private static final SdkField<String> NAME_HINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameHint").getter(RouteMatrixMatchingOptions.getter(RouteMatrixMatchingOptions::nameHint)).setter(RouteMatrixMatchingOptions.setter(Builder::nameHint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameHint").build()}).build();
    private static final SdkField<Long> ON_ROAD_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OnRoadThreshold").getter(RouteMatrixMatchingOptions.getter(RouteMatrixMatchingOptions::onRoadThreshold)).setter(RouteMatrixMatchingOptions.setter(Builder::onRoadThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnRoadThreshold").build()}).build();
    private static final SdkField<Long> RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Radius").getter(RouteMatrixMatchingOptions.getter(RouteMatrixMatchingOptions::radius)).setter(RouteMatrixMatchingOptions.setter(Builder::radius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(RouteMatrixMatchingOptions.getter(RouteMatrixMatchingOptions::strategyAsString)).setter(RouteMatrixMatchingOptions.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_HINT_FIELD, ON_ROAD_THRESHOLD_FIELD, RADIUS_FIELD, STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixMatchingOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nameHint;
    private final Long onRoadThreshold;
    private final Long radius;
    private final String strategy;

    private RouteMatrixMatchingOptions(BuilderImpl builder) {
        this.nameHint = builder.nameHint;
        this.onRoadThreshold = builder.onRoadThreshold;
        this.radius = builder.radius;
        this.strategy = builder.strategy;
    }

    public final String nameHint() {
        return this.nameHint;
    }

    public final Long onRoadThreshold() {
        return this.onRoadThreshold;
    }

    public final Long radius() {
        return this.radius;
    }

    public final MatchingStrategy strategy() {
        return MatchingStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameHint());
        hashCode = 31 * hashCode + Objects.hashCode(this.onRoadThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.radius());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixMatchingOptions)) {
            return false;
        }
        RouteMatrixMatchingOptions other = (RouteMatrixMatchingOptions)obj;
        return Objects.equals(this.nameHint(), other.nameHint()) && Objects.equals(this.onRoadThreshold(), other.onRoadThreshold()) && Objects.equals(this.radius(), other.radius()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixMatchingOptions").add("NameHint", (Object)(this.nameHint() == null ? null : "*** Sensitive Data Redacted ***")).add("OnRoadThreshold", (Object)this.onRoadThreshold()).add("Radius", (Object)this.radius()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NameHint": {
                return Optional.ofNullable(clazz.cast(this.nameHint()));
            }
            case "OnRoadThreshold": {
                return Optional.ofNullable(clazz.cast(this.onRoadThreshold()));
            }
            case "Radius": {
                return Optional.ofNullable(clazz.cast(this.radius()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NameHint", NAME_HINT_FIELD);
        map.put("OnRoadThreshold", ON_ROAD_THRESHOLD_FIELD);
        map.put("Radius", RADIUS_FIELD);
        map.put("Strategy", STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixMatchingOptions, T> g) {
        return obj -> g.apply((RouteMatrixMatchingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nameHint;
        private Long onRoadThreshold;
        private Long radius;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixMatchingOptions model) {
            this.nameHint(model.nameHint);
            this.onRoadThreshold(model.onRoadThreshold);
            this.radius(model.radius);
            this.strategy(model.strategy);
        }

        public final String getNameHint() {
            return this.nameHint;
        }

        public final void setNameHint(String nameHint) {
            this.nameHint = nameHint;
        }

        @Override
        public final Builder nameHint(String nameHint) {
            this.nameHint = nameHint;
            return this;
        }

        public final Long getOnRoadThreshold() {
            return this.onRoadThreshold;
        }

        public final void setOnRoadThreshold(Long onRoadThreshold) {
            this.onRoadThreshold = onRoadThreshold;
        }

        @Override
        public final Builder onRoadThreshold(Long onRoadThreshold) {
            this.onRoadThreshold = onRoadThreshold;
            return this;
        }

        public final Long getRadius() {
            return this.radius;
        }

        public final void setRadius(Long radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Long radius) {
            this.radius = radius;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(MatchingStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public RouteMatrixMatchingOptions build() {
            return new RouteMatrixMatchingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixMatchingOptions> {
        public Builder nameHint(String var1);

        public Builder onRoadThreshold(Long var1);

        public Builder radius(Long var1);

        public Builder strategy(String var1);

        public Builder strategy(MatchingStrategy var1);
    }
}

