/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixMatchingOptions;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixSideOfStreetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixDestinationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixDestinationOptions> {
    private static final SdkField<Long> AVOID_ACTIONS_FOR_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AvoidActionsForDistance").getter(RouteMatrixDestinationOptions.getter(RouteMatrixDestinationOptions::avoidActionsForDistance)).setter(RouteMatrixDestinationOptions.setter(Builder::avoidActionsForDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidActionsForDistance").build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(RouteMatrixDestinationOptions.getter(RouteMatrixDestinationOptions::heading)).setter(RouteMatrixDestinationOptions.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<RouteMatrixMatchingOptions> MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matching").getter(RouteMatrixDestinationOptions.getter(RouteMatrixDestinationOptions::matching)).setter(RouteMatrixDestinationOptions.setter(Builder::matching)).constructor(RouteMatrixMatchingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()}).build();
    private static final SdkField<RouteMatrixSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SideOfStreet").getter(RouteMatrixDestinationOptions.getter(RouteMatrixDestinationOptions::sideOfStreet)).setter(RouteMatrixDestinationOptions.setter(Builder::sideOfStreet)).constructor(RouteMatrixSideOfStreetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_ACTIONS_FOR_DISTANCE_FIELD, HEADING_FIELD, MATCHING_FIELD, SIDE_OF_STREET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixDestinationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long avoidActionsForDistance;
    private final Double heading;
    private final RouteMatrixMatchingOptions matching;
    private final RouteMatrixSideOfStreetOptions sideOfStreet;

    private RouteMatrixDestinationOptions(BuilderImpl builder) {
        this.avoidActionsForDistance = builder.avoidActionsForDistance;
        this.heading = builder.heading;
        this.matching = builder.matching;
        this.sideOfStreet = builder.sideOfStreet;
    }

    public final Long avoidActionsForDistance() {
        return this.avoidActionsForDistance;
    }

    public final Double heading() {
        return this.heading;
    }

    public final RouteMatrixMatchingOptions matching() {
        return this.matching;
    }

    public final RouteMatrixSideOfStreetOptions sideOfStreet() {
        return this.sideOfStreet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidActionsForDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.matching());
        hashCode = 31 * hashCode + Objects.hashCode(this.sideOfStreet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixDestinationOptions)) {
            return false;
        }
        RouteMatrixDestinationOptions other = (RouteMatrixDestinationOptions)obj;
        return Objects.equals(this.avoidActionsForDistance(), other.avoidActionsForDistance()) && Objects.equals(this.heading(), other.heading()) && Objects.equals(this.matching(), other.matching()) && Objects.equals(this.sideOfStreet(), other.sideOfStreet());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixDestinationOptions").add("AvoidActionsForDistance", (Object)this.avoidActionsForDistance()).add("Heading", (Object)this.heading()).add("Matching", (Object)this.matching()).add("SideOfStreet", (Object)this.sideOfStreet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvoidActionsForDistance": {
                return Optional.ofNullable(clazz.cast(this.avoidActionsForDistance()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Matching": {
                return Optional.ofNullable(clazz.cast(this.matching()));
            }
            case "SideOfStreet": {
                return Optional.ofNullable(clazz.cast(this.sideOfStreet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvoidActionsForDistance", AVOID_ACTIONS_FOR_DISTANCE_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Matching", MATCHING_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixDestinationOptions, T> g) {
        return obj -> g.apply((RouteMatrixDestinationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long avoidActionsForDistance;
        private Double heading;
        private RouteMatrixMatchingOptions matching;
        private RouteMatrixSideOfStreetOptions sideOfStreet;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixDestinationOptions model) {
            this.avoidActionsForDistance(model.avoidActionsForDistance);
            this.heading(model.heading);
            this.matching(model.matching);
            this.sideOfStreet(model.sideOfStreet);
        }

        public final Long getAvoidActionsForDistance() {
            return this.avoidActionsForDistance;
        }

        public final void setAvoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
        }

        @Override
        public final Builder avoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final RouteMatrixMatchingOptions.Builder getMatching() {
            return this.matching != null ? this.matching.toBuilder() : null;
        }

        public final void setMatching(RouteMatrixMatchingOptions.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(RouteMatrixMatchingOptions matching) {
            this.matching = matching;
            return this;
        }

        public final RouteMatrixSideOfStreetOptions.Builder getSideOfStreet() {
            return this.sideOfStreet != null ? this.sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(RouteMatrixSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(RouteMatrixSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        public RouteMatrixDestinationOptions build() {
            return new RouteMatrixDestinationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixDestinationOptions> {
        public Builder avoidActionsForDistance(Long var1);

        public Builder heading(Double var1);

        public Builder matching(RouteMatrixMatchingOptions var1);

        default public Builder matching(Consumer<RouteMatrixMatchingOptions.Builder> matching) {
            return this.matching((RouteMatrixMatchingOptions)((RouteMatrixMatchingOptions.Builder)RouteMatrixMatchingOptions.builder().applyMutation(matching)).build());
        }

        public Builder sideOfStreet(RouteMatrixSideOfStreetOptions var1);

        default public Builder sideOfStreet(Consumer<RouteMatrixSideOfStreetOptions.Builder> sideOfStreet) {
            return this.sideOfStreet((RouteMatrixSideOfStreetOptions)((RouteMatrixSideOfStreetOptions.Builder)RouteMatrixSideOfStreetOptions.builder().applyMutation(sideOfStreet)).build());
        }
    }
}

