/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteVehicleIncidentType {
    ACCIDENT("Accident"),
    CONGESTION("Congestion"),
    CONSTRUCTION("Construction"),
    DISABLED_VEHICLE("DisabledVehicle"),
    LANE_RESTRICTION("LaneRestriction"),
    MASS_TRANSIT("MassTransit"),
    OTHER("Other"),
    PLANNED_EVENT("PlannedEvent"),
    ROAD_CLOSURE("RoadClosure"),
    ROAD_HAZARD("RoadHazard"),
    WEATHER("Weather"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteVehicleIncidentType> VALUE_MAP;
    private final String value;

    private RouteVehicleIncidentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteVehicleIncidentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteVehicleIncidentType> knownValues() {
        EnumSet<RouteVehicleIncidentType> knownValues = EnumSet.allOf(RouteVehicleIncidentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteVehicleIncidentType.class, RouteVehicleIncidentType::toString);
    }
}

