/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RoadSnapNoticeCode;
import software.amazon.awssdk.services.georoutes.model.RoadSnapTracePointIndexListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoadSnapNotice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoadSnapNotice> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(RoadSnapNotice.getter(RoadSnapNotice::codeAsString)).setter(RoadSnapNotice.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(RoadSnapNotice.getter(RoadSnapNotice::title)).setter(RoadSnapNotice.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<List<Integer>> TRACE_POINT_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TracePointIndexes").getter(RoadSnapNotice.getter(RoadSnapNotice::tracePointIndexes)).setter(RoadSnapNotice.setter(Builder::tracePointIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracePointIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, TITLE_FIELD, TRACE_POINT_INDEXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoadSnapNotice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String title;
    private final List<Integer> tracePointIndexes;

    private RoadSnapNotice(BuilderImpl builder) {
        this.code = builder.code;
        this.title = builder.title;
        this.tracePointIndexes = builder.tracePointIndexes;
    }

    public final RoadSnapNoticeCode code() {
        return RoadSnapNoticeCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasTracePointIndexes() {
        return this.tracePointIndexes != null && !(this.tracePointIndexes instanceof SdkAutoConstructList);
    }

    public final List<Integer> tracePointIndexes() {
        return this.tracePointIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTracePointIndexes() ? this.tracePointIndexes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapNotice)) {
            return false;
        }
        RoadSnapNotice other = (RoadSnapNotice)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.title(), other.title()) && this.hasTracePointIndexes() == other.hasTracePointIndexes() && Objects.equals(this.tracePointIndexes(), other.tracePointIndexes());
    }

    public final String toString() {
        return ToString.builder((String)"RoadSnapNotice").add("Code", (Object)this.codeAsString()).add("Title", (Object)this.title()).add("TracePointIndexes", this.hasTracePointIndexes() ? this.tracePointIndexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "TracePointIndexes": {
                return Optional.ofNullable(clazz.cast(this.tracePointIndexes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Code", CODE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("TracePointIndexes", TRACE_POINT_INDEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapNotice, T> g) {
        return obj -> g.apply((RoadSnapNotice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String title;
        private List<Integer> tracePointIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapNotice model) {
            this.code(model.code);
            this.title(model.title);
            this.tracePointIndexes(model.tracePointIndexes);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(RoadSnapNoticeCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<Integer> getTracePointIndexes() {
            if (this.tracePointIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tracePointIndexes;
        }

        public final void setTracePointIndexes(Collection<Integer> tracePointIndexes) {
            this.tracePointIndexes = RoadSnapTracePointIndexListCopier.copy(tracePointIndexes);
        }

        @Override
        public final Builder tracePointIndexes(Collection<Integer> tracePointIndexes) {
            this.tracePointIndexes = RoadSnapTracePointIndexListCopier.copy(tracePointIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracePointIndexes(Integer ... tracePointIndexes) {
            this.tracePointIndexes(Arrays.asList(tracePointIndexes));
            return this;
        }

        public RoadSnapNotice build() {
            return new RoadSnapNotice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoadSnapNotice> {
        public Builder code(String var1);

        public Builder code(RoadSnapNoticeCode var1);

        public Builder title(String var1);

        public Builder tracePointIndexes(Collection<Integer> var1);

        public Builder tracePointIndexes(Integer ... var1);
    }
}

