/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.RouteNoticeImpact;
import software.amazon.awssdk.services.georoutes.model.RouteResponseNoticeCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteResponseNotice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteResponseNotice> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(RouteResponseNotice.getter(RouteResponseNotice::codeAsString)).setter(RouteResponseNotice.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Impact").getter(RouteResponseNotice.getter(RouteResponseNotice::impactAsString)).setter(RouteResponseNotice.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, IMPACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Code", CODE_FIELD);
            this.put("Impact", IMPACT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String impact;

    private RouteResponseNotice(BuilderImpl builder) {
        this.code = builder.code;
        this.impact = builder.impact;
    }

    public final RouteResponseNoticeCode code() {
        return RouteResponseNoticeCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final RouteNoticeImpact impact() {
        return RouteNoticeImpact.fromValue(this.impact);
    }

    public final String impactAsString() {
        return this.impact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.impactAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteResponseNotice)) {
            return false;
        }
        RouteResponseNotice other = (RouteResponseNotice)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.impactAsString(), other.impactAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteResponseNotice").add("Code", (Object)this.codeAsString()).add("Impact", (Object)this.impactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Impact": {
                return Optional.ofNullable(clazz.cast(this.impactAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RouteResponseNotice, T> g) {
        return obj -> g.apply((RouteResponseNotice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String impact;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteResponseNotice model) {
            this.code(model.code);
            this.impact(model.impact);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(RouteResponseNoticeCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getImpact() {
            return this.impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        @Override
        public final Builder impact(RouteNoticeImpact impact) {
            this.impact(impact == null ? null : impact.toString());
            return this;
        }

        public RouteResponseNotice build() {
            return new RouteResponseNotice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteResponseNotice> {
        public Builder code(String var1);

        public Builder code(RouteResponseNoticeCode var1);

        public Builder impact(String var1);

        public Builder impact(RouteNoticeImpact var1);
    }
}

