/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationRestCycles;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationRestProfile;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationServiceTimeTreatment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationDriverOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationDriverOptions> {
    private static final SdkField<WaypointOptimizationRestCycles> REST_CYCLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestCycles").getter(WaypointOptimizationDriverOptions.getter(WaypointOptimizationDriverOptions::restCycles)).setter(WaypointOptimizationDriverOptions.setter(Builder::restCycles)).constructor(WaypointOptimizationRestCycles::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestCycles").build()}).build();
    private static final SdkField<WaypointOptimizationRestProfile> REST_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestProfile").getter(WaypointOptimizationDriverOptions.getter(WaypointOptimizationDriverOptions::restProfile)).setter(WaypointOptimizationDriverOptions.setter(Builder::restProfile)).constructor(WaypointOptimizationRestProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestProfile").build()}).build();
    private static final SdkField<String> TREAT_SERVICE_TIME_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatServiceTimeAs").getter(WaypointOptimizationDriverOptions.getter(WaypointOptimizationDriverOptions::treatServiceTimeAsAsString)).setter(WaypointOptimizationDriverOptions.setter(Builder::treatServiceTimeAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatServiceTimeAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_CYCLES_FIELD, REST_PROFILE_FIELD, TREAT_SERVICE_TIME_AS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RestCycles", REST_CYCLES_FIELD);
            this.put("RestProfile", REST_PROFILE_FIELD);
            this.put("TreatServiceTimeAs", TREAT_SERVICE_TIME_AS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final WaypointOptimizationRestCycles restCycles;
    private final WaypointOptimizationRestProfile restProfile;
    private final String treatServiceTimeAs;

    private WaypointOptimizationDriverOptions(BuilderImpl builder) {
        this.restCycles = builder.restCycles;
        this.restProfile = builder.restProfile;
        this.treatServiceTimeAs = builder.treatServiceTimeAs;
    }

    public final WaypointOptimizationRestCycles restCycles() {
        return this.restCycles;
    }

    public final WaypointOptimizationRestProfile restProfile() {
        return this.restProfile;
    }

    public final WaypointOptimizationServiceTimeTreatment treatServiceTimeAs() {
        return WaypointOptimizationServiceTimeTreatment.fromValue(this.treatServiceTimeAs);
    }

    public final String treatServiceTimeAsAsString() {
        return this.treatServiceTimeAs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restCycles());
        hashCode = 31 * hashCode + Objects.hashCode(this.restProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatServiceTimeAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationDriverOptions)) {
            return false;
        }
        WaypointOptimizationDriverOptions other = (WaypointOptimizationDriverOptions)obj;
        return Objects.equals(this.restCycles(), other.restCycles()) && Objects.equals(this.restProfile(), other.restProfile()) && Objects.equals(this.treatServiceTimeAsAsString(), other.treatServiceTimeAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationDriverOptions").add("RestCycles", (Object)this.restCycles()).add("RestProfile", (Object)this.restProfile()).add("TreatServiceTimeAs", (Object)this.treatServiceTimeAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestCycles": {
                return Optional.ofNullable(clazz.cast(this.restCycles()));
            }
            case "RestProfile": {
                return Optional.ofNullable(clazz.cast(this.restProfile()));
            }
            case "TreatServiceTimeAs": {
                return Optional.ofNullable(clazz.cast(this.treatServiceTimeAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationDriverOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationDriverOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WaypointOptimizationRestCycles restCycles;
        private WaypointOptimizationRestProfile restProfile;
        private String treatServiceTimeAs;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationDriverOptions model) {
            this.restCycles(model.restCycles);
            this.restProfile(model.restProfile);
            this.treatServiceTimeAs(model.treatServiceTimeAs);
        }

        public final WaypointOptimizationRestCycles.Builder getRestCycles() {
            return this.restCycles != null ? this.restCycles.toBuilder() : null;
        }

        public final void setRestCycles(WaypointOptimizationRestCycles.BuilderImpl restCycles) {
            this.restCycles = restCycles != null ? restCycles.build() : null;
        }

        @Override
        public final Builder restCycles(WaypointOptimizationRestCycles restCycles) {
            this.restCycles = restCycles;
            return this;
        }

        public final WaypointOptimizationRestProfile.Builder getRestProfile() {
            return this.restProfile != null ? this.restProfile.toBuilder() : null;
        }

        public final void setRestProfile(WaypointOptimizationRestProfile.BuilderImpl restProfile) {
            this.restProfile = restProfile != null ? restProfile.build() : null;
        }

        @Override
        public final Builder restProfile(WaypointOptimizationRestProfile restProfile) {
            this.restProfile = restProfile;
            return this;
        }

        public final String getTreatServiceTimeAs() {
            return this.treatServiceTimeAs;
        }

        public final void setTreatServiceTimeAs(String treatServiceTimeAs) {
            this.treatServiceTimeAs = treatServiceTimeAs;
        }

        @Override
        public final Builder treatServiceTimeAs(String treatServiceTimeAs) {
            this.treatServiceTimeAs = treatServiceTimeAs;
            return this;
        }

        @Override
        public final Builder treatServiceTimeAs(WaypointOptimizationServiceTimeTreatment treatServiceTimeAs) {
            this.treatServiceTimeAs(treatServiceTimeAs == null ? null : treatServiceTimeAs.toString());
            return this;
        }

        public WaypointOptimizationDriverOptions build() {
            return new WaypointOptimizationDriverOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationDriverOptions> {
        public Builder restCycles(WaypointOptimizationRestCycles var1);

        default public Builder restCycles(Consumer<WaypointOptimizationRestCycles.Builder> restCycles) {
            return this.restCycles((WaypointOptimizationRestCycles)((WaypointOptimizationRestCycles.Builder)WaypointOptimizationRestCycles.builder().applyMutation(restCycles)).build());
        }

        public Builder restProfile(WaypointOptimizationRestProfile var1);

        default public Builder restProfile(Consumer<WaypointOptimizationRestProfile.Builder> restProfile) {
            return this.restProfile((WaypointOptimizationRestProfile)((WaypointOptimizationRestProfile.Builder)WaypointOptimizationRestProfile.builder().applyMutation(restProfile)).build());
        }

        public Builder treatServiceTimeAs(String var1);

        public Builder treatServiceTimeAs(WaypointOptimizationServiceTimeTreatment var1);
    }
}

