/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraint;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationFailedConstraintListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationImpedingWaypoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationImpedingWaypoint> {
    private static final SdkField<List<WaypointOptimizationFailedConstraint>> FAILED_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedConstraints").getter(WaypointOptimizationImpedingWaypoint.getter(WaypointOptimizationImpedingWaypoint::failedConstraints)).setter(WaypointOptimizationImpedingWaypoint.setter(Builder::failedConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationFailedConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WaypointOptimizationImpedingWaypoint.getter(WaypointOptimizationImpedingWaypoint::id)).setter(WaypointOptimizationImpedingWaypoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(WaypointOptimizationImpedingWaypoint.getter(WaypointOptimizationImpedingWaypoint::position)).setter(WaypointOptimizationImpedingWaypoint.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_CONSTRAINTS_FIELD, ID_FIELD, POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaypointOptimizationImpedingWaypoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<WaypointOptimizationFailedConstraint> failedConstraints;
    private final String id;
    private final List<Double> position;

    private WaypointOptimizationImpedingWaypoint(BuilderImpl builder) {
        this.failedConstraints = builder.failedConstraints;
        this.id = builder.id;
        this.position = builder.position;
    }

    public final boolean hasFailedConstraints() {
        return this.failedConstraints != null && !(this.failedConstraints instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationFailedConstraint> failedConstraints() {
        return this.failedConstraints;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedConstraints() ? this.failedConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationImpedingWaypoint)) {
            return false;
        }
        WaypointOptimizationImpedingWaypoint other = (WaypointOptimizationImpedingWaypoint)obj;
        return this.hasFailedConstraints() == other.hasFailedConstraints() && Objects.equals(this.failedConstraints(), other.failedConstraints()) && Objects.equals(this.id(), other.id()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationImpedingWaypoint").add("FailedConstraints", this.hasFailedConstraints() ? this.failedConstraints() : null).add("Id", (Object)this.id()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedConstraints": {
                return Optional.ofNullable(clazz.cast(this.failedConstraints()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailedConstraints", FAILED_CONSTRAINTS_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationImpedingWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationImpedingWaypoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WaypointOptimizationFailedConstraint> failedConstraints = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationImpedingWaypoint model) {
            this.failedConstraints(model.failedConstraints);
            this.id(model.id);
            this.position(model.position);
        }

        public final List<WaypointOptimizationFailedConstraint.Builder> getFailedConstraints() {
            List<WaypointOptimizationFailedConstraint.Builder> result = WaypointOptimizationFailedConstraintListCopier.copyToBuilder(this.failedConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedConstraints(Collection<WaypointOptimizationFailedConstraint.BuilderImpl> failedConstraints) {
            this.failedConstraints = WaypointOptimizationFailedConstraintListCopier.copyFromBuilder(failedConstraints);
        }

        @Override
        public final Builder failedConstraints(Collection<WaypointOptimizationFailedConstraint> failedConstraints) {
            this.failedConstraints = WaypointOptimizationFailedConstraintListCopier.copy(failedConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConstraints(WaypointOptimizationFailedConstraint ... failedConstraints) {
            this.failedConstraints(Arrays.asList(failedConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedConstraints(Consumer<WaypointOptimizationFailedConstraint.Builder> ... failedConstraints) {
            this.failedConstraints(Stream.of(failedConstraints).map(c -> (WaypointOptimizationFailedConstraint)((WaypointOptimizationFailedConstraint.Builder)WaypointOptimizationFailedConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public WaypointOptimizationImpedingWaypoint build() {
            return new WaypointOptimizationImpedingWaypoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationImpedingWaypoint> {
        public Builder failedConstraints(Collection<WaypointOptimizationFailedConstraint> var1);

        public Builder failedConstraints(WaypointOptimizationFailedConstraint ... var1);

        public Builder failedConstraints(Consumer<WaypointOptimizationFailedConstraint.Builder> ... var1);

        public Builder id(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);
    }
}

