/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteVehicleTravelStepType {
    ARRIVE("Arrive"),
    CONTINUE("Continue"),
    CONTINUE_HIGHWAY("ContinueHighway"),
    DEPART("Depart"),
    ENTER_HIGHWAY("EnterHighway"),
    EXIT("Exit"),
    KEEP("Keep"),
    RAMP("Ramp"),
    ROUNDABOUT_ENTER("RoundaboutEnter"),
    ROUNDABOUT_EXIT("RoundaboutExit"),
    ROUNDABOUT_PASS("RoundaboutPass"),
    TURN("Turn"),
    U_TURN("UTurn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteVehicleTravelStepType> VALUE_MAP;
    private final String value;

    private RouteVehicleTravelStepType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteVehicleTravelStepType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteVehicleTravelStepType> knownValues() {
        EnumSet<RouteVehicleTravelStepType> knownValues = EnumSet.allOf(RouteVehicleTravelStepType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteVehicleTravelStepType.class, RouteVehicleTravelStepType::toString);
    }
}

