/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteMatrixErrorCode {
    NO_MATCH("NoMatch"),
    NO_MATCH_DESTINATION("NoMatchDestination"),
    NO_MATCH_ORIGIN("NoMatchOrigin"),
    NO_ROUTE("NoRoute"),
    OUT_OF_BOUNDS("OutOfBounds"),
    OUT_OF_BOUNDS_DESTINATION("OutOfBoundsDestination"),
    OUT_OF_BOUNDS_ORIGIN("OutOfBoundsOrigin"),
    OTHER("Other"),
    VIOLATION("Violation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteMatrixErrorCode> VALUE_MAP;
    private final String value;

    private RouteMatrixErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteMatrixErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteMatrixErrorCode> knownValues() {
        EnumSet<RouteMatrixErrorCode> knownValues = EnumSet.allOf(RouteMatrixErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteMatrixErrorCode.class, RouteMatrixErrorCode::toString);
    }
}

