/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.CalculateRouteMatrixRequestDestinationsListCopier;
import software.amazon.awssdk.services.georoutes.model.CalculateRouteMatrixRequestOriginsListCopier;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixAllowOptions;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixAvoidanceOptions;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixBoundary;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixDestination;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixExclusionOptions;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixOrigin;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixTrafficOptions;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixTravelMode;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixTravelModeOptions;
import software.amazon.awssdk.services.georoutes.model.RoutingObjective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteMatrixRequest
extends GeoRoutesRequest
implements ToCopyableBuilder<Builder, CalculateRouteMatrixRequest> {
    private static final SdkField<RouteMatrixAllowOptions> ALLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Allow").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::allow)).setter(CalculateRouteMatrixRequest.setter(Builder::allow)).constructor(RouteMatrixAllowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()}).build();
    private static final SdkField<RouteMatrixAvoidanceOptions> AVOID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Avoid").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::avoid)).setter(CalculateRouteMatrixRequest.setter(Builder::avoid)).constructor(RouteMatrixAvoidanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::departNow)).setter(CalculateRouteMatrixRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::departureTime)).setter(CalculateRouteMatrixRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<List<RouteMatrixDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::destinations)).setter(CalculateRouteMatrixRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteMatrixDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteMatrixExclusionOptions> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclude").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::exclude)).setter(CalculateRouteMatrixRequest.setter(Builder::exclude)).constructor(RouteMatrixExclusionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::key)).setter(CalculateRouteMatrixRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<String> OPTIMIZE_ROUTING_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeRoutingFor").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::optimizeRoutingForAsString)).setter(CalculateRouteMatrixRequest.setter(Builder::optimizeRoutingFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeRoutingFor").build()}).build();
    private static final SdkField<List<RouteMatrixOrigin>> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Origins").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::origins)).setter(CalculateRouteMatrixRequest.setter(Builder::origins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteMatrixOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteMatrixBoundary> ROUTING_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingBoundary").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::routingBoundary)).setter(CalculateRouteMatrixRequest.setter(Builder::routingBoundary)).constructor(RouteMatrixBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingBoundary").build()}).build();
    private static final SdkField<RouteMatrixTrafficOptions> TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Traffic").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::traffic)).setter(CalculateRouteMatrixRequest.setter(Builder::traffic)).constructor(RouteMatrixTrafficOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::travelModeAsString)).setter(CalculateRouteMatrixRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<RouteMatrixTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TravelModeOptions").getter(CalculateRouteMatrixRequest.getter(CalculateRouteMatrixRequest::travelModeOptions)).setter(CalculateRouteMatrixRequest.setter(Builder::travelModeOptions)).constructor(RouteMatrixTravelModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, AVOID_FIELD, DEPART_NOW_FIELD, DEPARTURE_TIME_FIELD, DESTINATIONS_FIELD, EXCLUDE_FIELD, KEY_FIELD, OPTIMIZE_ROUTING_FOR_FIELD, ORIGINS_FIELD, ROUTING_BOUNDARY_FIELD, TRAFFIC_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Allow", ALLOW_FIELD);
            this.put("Avoid", AVOID_FIELD);
            this.put("DepartNow", DEPART_NOW_FIELD);
            this.put("DepartureTime", DEPARTURE_TIME_FIELD);
            this.put("Destinations", DESTINATIONS_FIELD);
            this.put("Exclude", EXCLUDE_FIELD);
            this.put("key", KEY_FIELD);
            this.put("OptimizeRoutingFor", OPTIMIZE_ROUTING_FOR_FIELD);
            this.put("Origins", ORIGINS_FIELD);
            this.put("RoutingBoundary", ROUTING_BOUNDARY_FIELD);
            this.put("Traffic", TRAFFIC_FIELD);
            this.put("TravelMode", TRAVEL_MODE_FIELD);
            this.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        }
    });
    private final RouteMatrixAllowOptions allow;
    private final RouteMatrixAvoidanceOptions avoid;
    private final Boolean departNow;
    private final String departureTime;
    private final List<RouteMatrixDestination> destinations;
    private final RouteMatrixExclusionOptions exclude;
    private final String key;
    private final String optimizeRoutingFor;
    private final List<RouteMatrixOrigin> origins;
    private final RouteMatrixBoundary routingBoundary;
    private final RouteMatrixTrafficOptions traffic;
    private final String travelMode;
    private final RouteMatrixTravelModeOptions travelModeOptions;

    private CalculateRouteMatrixRequest(BuilderImpl builder) {
        super(builder);
        this.allow = builder.allow;
        this.avoid = builder.avoid;
        this.departNow = builder.departNow;
        this.departureTime = builder.departureTime;
        this.destinations = builder.destinations;
        this.exclude = builder.exclude;
        this.key = builder.key;
        this.optimizeRoutingFor = builder.optimizeRoutingFor;
        this.origins = builder.origins;
        this.routingBoundary = builder.routingBoundary;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
    }

    public final RouteMatrixAllowOptions allow() {
        return this.allow;
    }

    public final RouteMatrixAvoidanceOptions avoid() {
        return this.avoid;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<RouteMatrixDestination> destinations() {
        return this.destinations;
    }

    public final RouteMatrixExclusionOptions exclude() {
        return this.exclude;
    }

    public final String key() {
        return this.key;
    }

    public final RoutingObjective optimizeRoutingFor() {
        return RoutingObjective.fromValue(this.optimizeRoutingFor);
    }

    public final String optimizeRoutingForAsString() {
        return this.optimizeRoutingFor;
    }

    public final boolean hasOrigins() {
        return this.origins != null && !(this.origins instanceof SdkAutoConstructList);
    }

    public final List<RouteMatrixOrigin> origins() {
        return this.origins;
    }

    public final RouteMatrixBoundary routingBoundary() {
        return this.routingBoundary;
    }

    public final RouteMatrixTrafficOptions traffic() {
        return this.traffic;
    }

    public final RouteMatrixTravelMode travelMode() {
        return RouteMatrixTravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final RouteMatrixTravelModeOptions travelModeOptions() {
        return this.travelModeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allow());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoid());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeRoutingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigins() ? this.origins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routingBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.traffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixRequest)) {
            return false;
        }
        CalculateRouteMatrixRequest other = (CalculateRouteMatrixRequest)((Object)obj);
        return Objects.equals(this.allow(), other.allow()) && Objects.equals(this.avoid(), other.avoid()) && Objects.equals(this.departNow(), other.departNow()) && Objects.equals(this.departureTime(), other.departureTime()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.exclude(), other.exclude()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.optimizeRoutingForAsString(), other.optimizeRoutingForAsString()) && this.hasOrigins() == other.hasOrigins() && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.routingBoundary(), other.routingBoundary()) && Objects.equals(this.traffic(), other.traffic()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.travelModeOptions(), other.travelModeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteMatrixRequest").add("Allow", (Object)this.allow()).add("Avoid", (Object)this.avoid()).add("DepartNow", (Object)this.departNow()).add("DepartureTime", (Object)this.departureTime()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("Exclude", (Object)this.exclude()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("OptimizeRoutingFor", (Object)this.optimizeRoutingForAsString()).add("Origins", this.hasOrigins() ? this.origins() : null).add("RoutingBoundary", (Object)this.routingBoundary()).add("Traffic", (Object)this.traffic()).add("TravelMode", (Object)this.travelModeAsString()).add("TravelModeOptions", (Object)this.travelModeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Allow": {
                return Optional.ofNullable(clazz.cast(this.allow()));
            }
            case "Avoid": {
                return Optional.ofNullable(clazz.cast(this.avoid()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "OptimizeRoutingFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeRoutingForAsString()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "RoutingBoundary": {
                return Optional.ofNullable(clazz.cast(this.routingBoundary()));
            }
            case "Traffic": {
                return Optional.ofNullable(clazz.cast(this.traffic()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TravelModeOptions": {
                return Optional.ofNullable(clazz.cast(this.travelModeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixRequest, T> g) {
        return obj -> g.apply((CalculateRouteMatrixRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesRequest.BuilderImpl
    implements Builder {
        private RouteMatrixAllowOptions allow;
        private RouteMatrixAvoidanceOptions avoid;
        private Boolean departNow;
        private String departureTime;
        private List<RouteMatrixDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private RouteMatrixExclusionOptions exclude;
        private String key;
        private String optimizeRoutingFor;
        private List<RouteMatrixOrigin> origins = DefaultSdkAutoConstructList.getInstance();
        private RouteMatrixBoundary routingBoundary;
        private RouteMatrixTrafficOptions traffic;
        private String travelMode;
        private RouteMatrixTravelModeOptions travelModeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixRequest model) {
            super(model);
            this.allow(model.allow);
            this.avoid(model.avoid);
            this.departNow(model.departNow);
            this.departureTime(model.departureTime);
            this.destinations(model.destinations);
            this.exclude(model.exclude);
            this.key(model.key);
            this.optimizeRoutingFor(model.optimizeRoutingFor);
            this.origins(model.origins);
            this.routingBoundary(model.routingBoundary);
            this.traffic(model.traffic);
            this.travelMode(model.travelMode);
            this.travelModeOptions(model.travelModeOptions);
        }

        public final RouteMatrixAllowOptions.Builder getAllow() {
            return this.allow != null ? this.allow.toBuilder() : null;
        }

        public final void setAllow(RouteMatrixAllowOptions.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(RouteMatrixAllowOptions allow) {
            this.allow = allow;
            return this;
        }

        public final RouteMatrixAvoidanceOptions.Builder getAvoid() {
            return this.avoid != null ? this.avoid.toBuilder() : null;
        }

        public final void setAvoid(RouteMatrixAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(RouteMatrixAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final List<RouteMatrixDestination.Builder> getDestinations() {
            List<RouteMatrixDestination.Builder> result = CalculateRouteMatrixRequestDestinationsListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<RouteMatrixDestination.BuilderImpl> destinations) {
            this.destinations = CalculateRouteMatrixRequestDestinationsListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<RouteMatrixDestination> destinations) {
            this.destinations = CalculateRouteMatrixRequestDestinationsListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(RouteMatrixDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<RouteMatrixDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (RouteMatrixDestination)((RouteMatrixDestination.Builder)RouteMatrixDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteMatrixExclusionOptions.Builder getExclude() {
            return this.exclude != null ? this.exclude.toBuilder() : null;
        }

        public final void setExclude(RouteMatrixExclusionOptions.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(RouteMatrixExclusionOptions exclude) {
            this.exclude = exclude;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getOptimizeRoutingFor() {
            return this.optimizeRoutingFor;
        }

        public final void setOptimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
        }

        @Override
        public final Builder optimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
            return this;
        }

        @Override
        public final Builder optimizeRoutingFor(RoutingObjective optimizeRoutingFor) {
            this.optimizeRoutingFor(optimizeRoutingFor == null ? null : optimizeRoutingFor.toString());
            return this;
        }

        public final List<RouteMatrixOrigin.Builder> getOrigins() {
            List<RouteMatrixOrigin.Builder> result = CalculateRouteMatrixRequestOriginsListCopier.copyToBuilder(this.origins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrigins(Collection<RouteMatrixOrigin.BuilderImpl> origins) {
            this.origins = CalculateRouteMatrixRequestOriginsListCopier.copyFromBuilder(origins);
        }

        @Override
        public final Builder origins(Collection<RouteMatrixOrigin> origins) {
            this.origins = CalculateRouteMatrixRequestOriginsListCopier.copy(origins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origins(RouteMatrixOrigin ... origins) {
            this.origins(Arrays.asList(origins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origins(Consumer<RouteMatrixOrigin.Builder> ... origins) {
            this.origins(Stream.of(origins).map(c -> (RouteMatrixOrigin)((RouteMatrixOrigin.Builder)RouteMatrixOrigin.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteMatrixBoundary.Builder getRoutingBoundary() {
            return this.routingBoundary != null ? this.routingBoundary.toBuilder() : null;
        }

        public final void setRoutingBoundary(RouteMatrixBoundary.BuilderImpl routingBoundary) {
            this.routingBoundary = routingBoundary != null ? routingBoundary.build() : null;
        }

        @Override
        public final Builder routingBoundary(RouteMatrixBoundary routingBoundary) {
            this.routingBoundary = routingBoundary;
            return this;
        }

        public final RouteMatrixTrafficOptions.Builder getTraffic() {
            return this.traffic != null ? this.traffic.toBuilder() : null;
        }

        public final void setTraffic(RouteMatrixTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(RouteMatrixTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RouteMatrixTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final RouteMatrixTravelModeOptions.Builder getTravelModeOptions() {
            return this.travelModeOptions != null ? this.travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(RouteMatrixTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(RouteMatrixTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRouteMatrixRequest build() {
            return new CalculateRouteMatrixRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoRoutesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteMatrixRequest> {
        public Builder allow(RouteMatrixAllowOptions var1);

        default public Builder allow(Consumer<RouteMatrixAllowOptions.Builder> allow) {
            return this.allow((RouteMatrixAllowOptions)((RouteMatrixAllowOptions.Builder)RouteMatrixAllowOptions.builder().applyMutation(allow)).build());
        }

        public Builder avoid(RouteMatrixAvoidanceOptions var1);

        default public Builder avoid(Consumer<RouteMatrixAvoidanceOptions.Builder> avoid) {
            return this.avoid((RouteMatrixAvoidanceOptions)((RouteMatrixAvoidanceOptions.Builder)RouteMatrixAvoidanceOptions.builder().applyMutation(avoid)).build());
        }

        public Builder departNow(Boolean var1);

        public Builder departureTime(String var1);

        public Builder destinations(Collection<RouteMatrixDestination> var1);

        public Builder destinations(RouteMatrixDestination ... var1);

        public Builder destinations(Consumer<RouteMatrixDestination.Builder> ... var1);

        public Builder exclude(RouteMatrixExclusionOptions var1);

        default public Builder exclude(Consumer<RouteMatrixExclusionOptions.Builder> exclude) {
            return this.exclude((RouteMatrixExclusionOptions)((RouteMatrixExclusionOptions.Builder)RouteMatrixExclusionOptions.builder().applyMutation(exclude)).build());
        }

        public Builder key(String var1);

        public Builder optimizeRoutingFor(String var1);

        public Builder optimizeRoutingFor(RoutingObjective var1);

        public Builder origins(Collection<RouteMatrixOrigin> var1);

        public Builder origins(RouteMatrixOrigin ... var1);

        public Builder origins(Consumer<RouteMatrixOrigin.Builder> ... var1);

        public Builder routingBoundary(RouteMatrixBoundary var1);

        default public Builder routingBoundary(Consumer<RouteMatrixBoundary.Builder> routingBoundary) {
            return this.routingBoundary((RouteMatrixBoundary)((RouteMatrixBoundary.Builder)RouteMatrixBoundary.builder().applyMutation(routingBoundary)).build());
        }

        public Builder traffic(RouteMatrixTrafficOptions var1);

        default public Builder traffic(Consumer<RouteMatrixTrafficOptions.Builder> traffic) {
            return this.traffic((RouteMatrixTrafficOptions)((RouteMatrixTrafficOptions.Builder)RouteMatrixTrafficOptions.builder().applyMutation(traffic)).build());
        }

        public Builder travelMode(String var1);

        public Builder travelMode(RouteMatrixTravelMode var1);

        public Builder travelModeOptions(RouteMatrixTravelModeOptions var1);

        default public Builder travelModeOptions(Consumer<RouteMatrixTravelModeOptions.Builder> travelModeOptions) {
            return this.travelModeOptions((RouteMatrixTravelModeOptions)((RouteMatrixTravelModeOptions.Builder)RouteMatrixTravelModeOptions.builder().applyMutation(travelModeOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

