/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceArea;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceOptionsAreasListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationAvoidanceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationAvoidanceOptions> {
    private static final SdkField<List<WaypointOptimizationAvoidanceArea>> AREAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Areas").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::areas)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::areas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Areas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationAvoidanceArea::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CAR_SHUTTLE_TRAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CarShuttleTrains").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::carShuttleTrains)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::carShuttleTrains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarShuttleTrains").build()}).build();
    private static final SdkField<Boolean> CONTROLLED_ACCESS_HIGHWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ControlledAccessHighways").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::controlledAccessHighways)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::controlledAccessHighways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlledAccessHighways").build()}).build();
    private static final SdkField<Boolean> DIRT_ROADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DirtRoads").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::dirtRoads)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::dirtRoads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirtRoads").build()}).build();
    private static final SdkField<Boolean> FERRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ferries").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::ferries)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::ferries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ferries").build()}).build();
    private static final SdkField<Boolean> TOLL_ROADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TollRoads").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::tollRoads)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::tollRoads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollRoads").build()}).build();
    private static final SdkField<Boolean> TUNNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Tunnels").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::tunnels)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::tunnels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tunnels").build()}).build();
    private static final SdkField<Boolean> U_TURNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UTurns").getter(WaypointOptimizationAvoidanceOptions.getter(WaypointOptimizationAvoidanceOptions::uTurns)).setter(WaypointOptimizationAvoidanceOptions.setter(Builder::uTurns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UTurns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREAS_FIELD, CAR_SHUTTLE_TRAINS_FIELD, CONTROLLED_ACCESS_HIGHWAYS_FIELD, DIRT_ROADS_FIELD, FERRIES_FIELD, TOLL_ROADS_FIELD, TUNNELS_FIELD, U_TURNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Areas", AREAS_FIELD);
            this.put("CarShuttleTrains", CAR_SHUTTLE_TRAINS_FIELD);
            this.put("ControlledAccessHighways", CONTROLLED_ACCESS_HIGHWAYS_FIELD);
            this.put("DirtRoads", DIRT_ROADS_FIELD);
            this.put("Ferries", FERRIES_FIELD);
            this.put("TollRoads", TOLL_ROADS_FIELD);
            this.put("Tunnels", TUNNELS_FIELD);
            this.put("UTurns", U_TURNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<WaypointOptimizationAvoidanceArea> areas;
    private final Boolean carShuttleTrains;
    private final Boolean controlledAccessHighways;
    private final Boolean dirtRoads;
    private final Boolean ferries;
    private final Boolean tollRoads;
    private final Boolean tunnels;
    private final Boolean uTurns;

    private WaypointOptimizationAvoidanceOptions(BuilderImpl builder) {
        this.areas = builder.areas;
        this.carShuttleTrains = builder.carShuttleTrains;
        this.controlledAccessHighways = builder.controlledAccessHighways;
        this.dirtRoads = builder.dirtRoads;
        this.ferries = builder.ferries;
        this.tollRoads = builder.tollRoads;
        this.tunnels = builder.tunnels;
        this.uTurns = builder.uTurns;
    }

    public final boolean hasAreas() {
        return this.areas != null && !(this.areas instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationAvoidanceArea> areas() {
        return this.areas;
    }

    public final Boolean carShuttleTrains() {
        return this.carShuttleTrains;
    }

    public final Boolean controlledAccessHighways() {
        return this.controlledAccessHighways;
    }

    public final Boolean dirtRoads() {
        return this.dirtRoads;
    }

    public final Boolean ferries() {
        return this.ferries;
    }

    public final Boolean tollRoads() {
        return this.tollRoads;
    }

    public final Boolean tunnels() {
        return this.tunnels;
    }

    public final Boolean uTurns() {
        return this.uTurns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAreas() ? this.areas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.carShuttleTrains());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlledAccessHighways());
        hashCode = 31 * hashCode + Objects.hashCode(this.dirtRoads());
        hashCode = 31 * hashCode + Objects.hashCode(this.ferries());
        hashCode = 31 * hashCode + Objects.hashCode(this.tollRoads());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnels());
        hashCode = 31 * hashCode + Objects.hashCode(this.uTurns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationAvoidanceOptions)) {
            return false;
        }
        WaypointOptimizationAvoidanceOptions other = (WaypointOptimizationAvoidanceOptions)obj;
        return this.hasAreas() == other.hasAreas() && Objects.equals(this.areas(), other.areas()) && Objects.equals(this.carShuttleTrains(), other.carShuttleTrains()) && Objects.equals(this.controlledAccessHighways(), other.controlledAccessHighways()) && Objects.equals(this.dirtRoads(), other.dirtRoads()) && Objects.equals(this.ferries(), other.ferries()) && Objects.equals(this.tollRoads(), other.tollRoads()) && Objects.equals(this.tunnels(), other.tunnels()) && Objects.equals(this.uTurns(), other.uTurns());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationAvoidanceOptions").add("Areas", this.hasAreas() ? this.areas() : null).add("CarShuttleTrains", (Object)this.carShuttleTrains()).add("ControlledAccessHighways", (Object)this.controlledAccessHighways()).add("DirtRoads", (Object)this.dirtRoads()).add("Ferries", (Object)this.ferries()).add("TollRoads", (Object)this.tollRoads()).add("Tunnels", (Object)this.tunnels()).add("UTurns", (Object)this.uTurns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Areas": {
                return Optional.ofNullable(clazz.cast(this.areas()));
            }
            case "CarShuttleTrains": {
                return Optional.ofNullable(clazz.cast(this.carShuttleTrains()));
            }
            case "ControlledAccessHighways": {
                return Optional.ofNullable(clazz.cast(this.controlledAccessHighways()));
            }
            case "DirtRoads": {
                return Optional.ofNullable(clazz.cast(this.dirtRoads()));
            }
            case "Ferries": {
                return Optional.ofNullable(clazz.cast(this.ferries()));
            }
            case "TollRoads": {
                return Optional.ofNullable(clazz.cast(this.tollRoads()));
            }
            case "Tunnels": {
                return Optional.ofNullable(clazz.cast(this.tunnels()));
            }
            case "UTurns": {
                return Optional.ofNullable(clazz.cast(this.uTurns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationAvoidanceOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationAvoidanceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WaypointOptimizationAvoidanceArea> areas = DefaultSdkAutoConstructList.getInstance();
        private Boolean carShuttleTrains;
        private Boolean controlledAccessHighways;
        private Boolean dirtRoads;
        private Boolean ferries;
        private Boolean tollRoads;
        private Boolean tunnels;
        private Boolean uTurns;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationAvoidanceOptions model) {
            this.areas(model.areas);
            this.carShuttleTrains(model.carShuttleTrains);
            this.controlledAccessHighways(model.controlledAccessHighways);
            this.dirtRoads(model.dirtRoads);
            this.ferries(model.ferries);
            this.tollRoads(model.tollRoads);
            this.tunnels(model.tunnels);
            this.uTurns(model.uTurns);
        }

        public final List<WaypointOptimizationAvoidanceArea.Builder> getAreas() {
            List<WaypointOptimizationAvoidanceArea.Builder> result = WaypointOptimizationAvoidanceOptionsAreasListCopier.copyToBuilder(this.areas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAreas(Collection<WaypointOptimizationAvoidanceArea.BuilderImpl> areas) {
            this.areas = WaypointOptimizationAvoidanceOptionsAreasListCopier.copyFromBuilder(areas);
        }

        @Override
        public final Builder areas(Collection<WaypointOptimizationAvoidanceArea> areas) {
            this.areas = WaypointOptimizationAvoidanceOptionsAreasListCopier.copy(areas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(WaypointOptimizationAvoidanceArea ... areas) {
            this.areas(Arrays.asList(areas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(Consumer<WaypointOptimizationAvoidanceArea.Builder> ... areas) {
            this.areas(Stream.of(areas).map(c -> (WaypointOptimizationAvoidanceArea)((WaypointOptimizationAvoidanceArea.Builder)WaypointOptimizationAvoidanceArea.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCarShuttleTrains() {
            return this.carShuttleTrains;
        }

        public final void setCarShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
        }

        @Override
        public final Builder carShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
            return this;
        }

        public final Boolean getControlledAccessHighways() {
            return this.controlledAccessHighways;
        }

        public final void setControlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
        }

        @Override
        public final Builder controlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
            return this;
        }

        public final Boolean getDirtRoads() {
            return this.dirtRoads;
        }

        public final void setDirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
        }

        @Override
        public final Builder dirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
            return this;
        }

        public final Boolean getFerries() {
            return this.ferries;
        }

        public final void setFerries(Boolean ferries) {
            this.ferries = ferries;
        }

        @Override
        public final Builder ferries(Boolean ferries) {
            this.ferries = ferries;
            return this;
        }

        public final Boolean getTollRoads() {
            return this.tollRoads;
        }

        public final void setTollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
        }

        @Override
        public final Builder tollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
            return this;
        }

        public final Boolean getTunnels() {
            return this.tunnels;
        }

        public final void setTunnels(Boolean tunnels) {
            this.tunnels = tunnels;
        }

        @Override
        public final Builder tunnels(Boolean tunnels) {
            this.tunnels = tunnels;
            return this;
        }

        public final Boolean getUTurns() {
            return this.uTurns;
        }

        public final void setUTurns(Boolean uTurns) {
            this.uTurns = uTurns;
        }

        @Override
        public final Builder uTurns(Boolean uTurns) {
            this.uTurns = uTurns;
            return this;
        }

        public WaypointOptimizationAvoidanceOptions build() {
            return new WaypointOptimizationAvoidanceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationAvoidanceOptions> {
        public Builder areas(Collection<WaypointOptimizationAvoidanceArea> var1);

        public Builder areas(WaypointOptimizationAvoidanceArea ... var1);

        public Builder areas(Consumer<WaypointOptimizationAvoidanceArea.Builder> ... var1);

        public Builder carShuttleTrains(Boolean var1);

        public Builder controlledAccessHighways(Boolean var1);

        public Builder dirtRoads(Boolean var1);

        public Builder ferries(Boolean var1);

        public Builder tollRoads(Boolean var1);

        public Builder tunnels(Boolean var1);

        public Builder uTurns(Boolean var1);
    }
}

