/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.DistanceThresholdListCopier;
import software.amazon.awssdk.services.georoutes.model.TimeThresholdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsolineThresholds
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsolineThresholds> {
    private static final SdkField<List<Long>> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Distance").getter(IsolineThresholds.getter(IsolineThresholds::distance)).setter(IsolineThresholds.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Time").getter(IsolineThresholds.getter(IsolineThresholds::time)).setter(IsolineThresholds.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Distance", DISTANCE_FIELD);
            this.put("Time", TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Long> distance;
    private final List<Long> time;

    private IsolineThresholds(BuilderImpl builder) {
        this.distance = builder.distance;
        this.time = builder.time;
    }

    public final boolean hasDistance() {
        return this.distance != null && !(this.distance instanceof SdkAutoConstructList);
    }

    public final List<Long> distance() {
        return this.distance;
    }

    public final boolean hasTime() {
        return this.time != null && !(this.time instanceof SdkAutoConstructList);
    }

    public final List<Long> time() {
        return this.time;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistance() ? this.distance() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTime() ? this.time() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineThresholds)) {
            return false;
        }
        IsolineThresholds other = (IsolineThresholds)obj;
        return this.hasDistance() == other.hasDistance() && Objects.equals(this.distance(), other.distance()) && this.hasTime() == other.hasTime() && Objects.equals(this.time(), other.time());
    }

    public final String toString() {
        return ToString.builder((String)"IsolineThresholds").add("Distance", this.hasDistance() ? this.distance() : null).add("Time", this.hasTime() ? this.time() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsolineThresholds, T> g) {
        return obj -> g.apply((IsolineThresholds)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Long> distance = DefaultSdkAutoConstructList.getInstance();
        private List<Long> time = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineThresholds model) {
            this.distance(model.distance);
            this.time(model.time);
        }

        public final Collection<Long> getDistance() {
            if (this.distance instanceof SdkAutoConstructList) {
                return null;
            }
            return this.distance;
        }

        public final void setDistance(Collection<Long> distance) {
            this.distance = DistanceThresholdListCopier.copy(distance);
        }

        @Override
        public final Builder distance(Collection<Long> distance) {
            this.distance = DistanceThresholdListCopier.copy(distance);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distance(Long ... distance) {
            this.distance(Arrays.asList(distance));
            return this;
        }

        public final Collection<Long> getTime() {
            if (this.time instanceof SdkAutoConstructList) {
                return null;
            }
            return this.time;
        }

        public final void setTime(Collection<Long> time) {
            this.time = TimeThresholdListCopier.copy(time);
        }

        @Override
        public final Builder time(Collection<Long> time) {
            this.time = TimeThresholdListCopier.copy(time);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder time(Long ... time) {
            this.time(Arrays.asList(time));
            return this;
        }

        public IsolineThresholds build() {
            return new IsolineThresholds(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsolineThresholds> {
        public Builder distance(Collection<Long> var1);

        public Builder distance(Long ... var1);

        public Builder time(Collection<Long> var1);

        public Builder time(Long ... var1);
    }
}

