/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.GeometryFormat;
import software.amazon.awssdk.services.georoutes.model.RoadSnapNotice;
import software.amazon.awssdk.services.georoutes.model.RoadSnapNoticeListCopier;
import software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedGeometry;
import software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePoint;
import software.amazon.awssdk.services.georoutes.model.RoadSnapSnappedTracePointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapToRoadsResponse
extends GeoRoutesResponse
implements ToCopyableBuilder<Builder, SnapToRoadsResponse> {
    private static final SdkField<List<RoadSnapNotice>> NOTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notices").getter(SnapToRoadsResponse.getter(SnapToRoadsResponse::notices)).setter(SnapToRoadsResponse.setter(Builder::notices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoadSnapNotice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(SnapToRoadsResponse.getter(SnapToRoadsResponse::pricingBucket)).setter(SnapToRoadsResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<RoadSnapSnappedGeometry> SNAPPED_GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnappedGeometry").getter(SnapToRoadsResponse.getter(SnapToRoadsResponse::snappedGeometry)).setter(SnapToRoadsResponse.setter(Builder::snappedGeometry)).constructor(RoadSnapSnappedGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometry").build()}).build();
    private static final SdkField<String> SNAPPED_GEOMETRY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnappedGeometryFormat").getter(SnapToRoadsResponse.getter(SnapToRoadsResponse::snappedGeometryFormatAsString)).setter(SnapToRoadsResponse.setter(Builder::snappedGeometryFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedGeometryFormat").build()}).build();
    private static final SdkField<List<RoadSnapSnappedTracePoint>> SNAPPED_TRACE_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnappedTracePoints").getter(SnapToRoadsResponse.getter(SnapToRoadsResponse::snappedTracePoints)).setter(SnapToRoadsResponse.setter(Builder::snappedTracePoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedTracePoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoadSnapSnappedTracePoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTICES_FIELD, PRICING_BUCKET_FIELD, SNAPPED_GEOMETRY_FIELD, SNAPPED_GEOMETRY_FORMAT_FIELD, SNAPPED_TRACE_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Notices", NOTICES_FIELD);
            this.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
            this.put("SnappedGeometry", SNAPPED_GEOMETRY_FIELD);
            this.put("SnappedGeometryFormat", SNAPPED_GEOMETRY_FORMAT_FIELD);
            this.put("SnappedTracePoints", SNAPPED_TRACE_POINTS_FIELD);
        }
    });
    private final List<RoadSnapNotice> notices;
    private final String pricingBucket;
    private final RoadSnapSnappedGeometry snappedGeometry;
    private final String snappedGeometryFormat;
    private final List<RoadSnapSnappedTracePoint> snappedTracePoints;

    private SnapToRoadsResponse(BuilderImpl builder) {
        super(builder);
        this.notices = builder.notices;
        this.pricingBucket = builder.pricingBucket;
        this.snappedGeometry = builder.snappedGeometry;
        this.snappedGeometryFormat = builder.snappedGeometryFormat;
        this.snappedTracePoints = builder.snappedTracePoints;
    }

    public final boolean hasNotices() {
        return this.notices != null && !(this.notices instanceof SdkAutoConstructList);
    }

    public final List<RoadSnapNotice> notices() {
        return this.notices;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final RoadSnapSnappedGeometry snappedGeometry() {
        return this.snappedGeometry;
    }

    public final GeometryFormat snappedGeometryFormat() {
        return GeometryFormat.fromValue(this.snappedGeometryFormat);
    }

    public final String snappedGeometryFormatAsString() {
        return this.snappedGeometryFormat;
    }

    public final boolean hasSnappedTracePoints() {
        return this.snappedTracePoints != null && !(this.snappedTracePoints instanceof SdkAutoConstructList);
    }

    public final List<RoadSnapSnappedTracePoint> snappedTracePoints() {
        return this.snappedTracePoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotices() ? this.notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.snappedGeometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.snappedGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnappedTracePoints() ? this.snappedTracePoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapToRoadsResponse)) {
            return false;
        }
        SnapToRoadsResponse other = (SnapToRoadsResponse)((Object)obj);
        return this.hasNotices() == other.hasNotices() && Objects.equals(this.notices(), other.notices()) && Objects.equals(this.pricingBucket(), other.pricingBucket()) && Objects.equals(this.snappedGeometry(), other.snappedGeometry()) && Objects.equals(this.snappedGeometryFormatAsString(), other.snappedGeometryFormatAsString()) && this.hasSnappedTracePoints() == other.hasSnappedTracePoints() && Objects.equals(this.snappedTracePoints(), other.snappedTracePoints());
    }

    public final String toString() {
        return ToString.builder((String)"SnapToRoadsResponse").add("Notices", this.hasNotices() ? this.notices() : null).add("PricingBucket", (Object)this.pricingBucket()).add("SnappedGeometry", (Object)this.snappedGeometry()).add("SnappedGeometryFormat", (Object)this.snappedGeometryFormatAsString()).add("SnappedTracePoints", this.hasSnappedTracePoints() ? this.snappedTracePoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Notices": {
                return Optional.ofNullable(clazz.cast(this.notices()));
            }
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "SnappedGeometry": {
                return Optional.ofNullable(clazz.cast(this.snappedGeometry()));
            }
            case "SnappedGeometryFormat": {
                return Optional.ofNullable(clazz.cast(this.snappedGeometryFormatAsString()));
            }
            case "SnappedTracePoints": {
                return Optional.ofNullable(clazz.cast(this.snappedTracePoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapToRoadsResponse, T> g) {
        return obj -> g.apply((SnapToRoadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesResponse.BuilderImpl
    implements Builder {
        private List<RoadSnapNotice> notices = DefaultSdkAutoConstructList.getInstance();
        private String pricingBucket;
        private RoadSnapSnappedGeometry snappedGeometry;
        private String snappedGeometryFormat;
        private List<RoadSnapSnappedTracePoint> snappedTracePoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapToRoadsResponse model) {
            super(model);
            this.notices(model.notices);
            this.pricingBucket(model.pricingBucket);
            this.snappedGeometry(model.snappedGeometry);
            this.snappedGeometryFormat(model.snappedGeometryFormat);
            this.snappedTracePoints(model.snappedTracePoints);
        }

        public final List<RoadSnapNotice.Builder> getNotices() {
            List<RoadSnapNotice.Builder> result = RoadSnapNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RoadSnapNotice.BuilderImpl> notices) {
            this.notices = RoadSnapNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RoadSnapNotice> notices) {
            this.notices = RoadSnapNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RoadSnapNotice ... notices) {
            this.notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RoadSnapNotice.Builder> ... notices) {
            this.notices(Stream.of(notices).map(c -> (RoadSnapNotice)((RoadSnapNotice.Builder)RoadSnapNotice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final RoadSnapSnappedGeometry.Builder getSnappedGeometry() {
            return this.snappedGeometry != null ? this.snappedGeometry.toBuilder() : null;
        }

        public final void setSnappedGeometry(RoadSnapSnappedGeometry.BuilderImpl snappedGeometry) {
            this.snappedGeometry = snappedGeometry != null ? snappedGeometry.build() : null;
        }

        @Override
        public final Builder snappedGeometry(RoadSnapSnappedGeometry snappedGeometry) {
            this.snappedGeometry = snappedGeometry;
            return this;
        }

        public final String getSnappedGeometryFormat() {
            return this.snappedGeometryFormat;
        }

        public final void setSnappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
        }

        @Override
        public final Builder snappedGeometryFormat(String snappedGeometryFormat) {
            this.snappedGeometryFormat = snappedGeometryFormat;
            return this;
        }

        @Override
        public final Builder snappedGeometryFormat(GeometryFormat snappedGeometryFormat) {
            this.snappedGeometryFormat(snappedGeometryFormat == null ? null : snappedGeometryFormat.toString());
            return this;
        }

        public final List<RoadSnapSnappedTracePoint.Builder> getSnappedTracePoints() {
            List<RoadSnapSnappedTracePoint.Builder> result = RoadSnapSnappedTracePointListCopier.copyToBuilder(this.snappedTracePoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnappedTracePoints(Collection<RoadSnapSnappedTracePoint.BuilderImpl> snappedTracePoints) {
            this.snappedTracePoints = RoadSnapSnappedTracePointListCopier.copyFromBuilder(snappedTracePoints);
        }

        @Override
        public final Builder snappedTracePoints(Collection<RoadSnapSnappedTracePoint> snappedTracePoints) {
            this.snappedTracePoints = RoadSnapSnappedTracePointListCopier.copy(snappedTracePoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedTracePoints(RoadSnapSnappedTracePoint ... snappedTracePoints) {
            this.snappedTracePoints(Arrays.asList(snappedTracePoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedTracePoints(Consumer<RoadSnapSnappedTracePoint.Builder> ... snappedTracePoints) {
            this.snappedTracePoints(Stream.of(snappedTracePoints).map(c -> (RoadSnapSnappedTracePoint)((RoadSnapSnappedTracePoint.Builder)RoadSnapSnappedTracePoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapToRoadsResponse build() {
            return new SnapToRoadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoRoutesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SnapToRoadsResponse> {
        public Builder notices(Collection<RoadSnapNotice> var1);

        public Builder notices(RoadSnapNotice ... var1);

        public Builder notices(Consumer<RoadSnapNotice.Builder> ... var1);

        public Builder pricingBucket(String var1);

        public Builder snappedGeometry(RoadSnapSnappedGeometry var1);

        default public Builder snappedGeometry(Consumer<RoadSnapSnappedGeometry.Builder> snappedGeometry) {
            return this.snappedGeometry((RoadSnapSnappedGeometry)((RoadSnapSnappedGeometry.Builder)RoadSnapSnappedGeometry.builder().applyMutation(snappedGeometry)).build());
        }

        public Builder snappedGeometryFormat(String var1);

        public Builder snappedGeometryFormat(GeometryFormat var1);

        public Builder snappedTracePoints(Collection<RoadSnapSnappedTracePoint> var1);

        public Builder snappedTracePoints(RoadSnapSnappedTracePoint ... var1);

        public Builder snappedTracePoints(Consumer<RoadSnapSnappedTracePoint.Builder> ... var1);
    }
}

