/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geomaps.model.ColorScheme;
import software.amazon.awssdk.services.geomaps.model.GeoMapsRequest;
import software.amazon.awssdk.services.geomaps.model.MapStyle;
import software.amazon.awssdk.services.geomaps.model.Variant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSpritesRequest
extends GeoMapsRequest
implements ToCopyableBuilder<Builder, GetSpritesRequest> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(GetSpritesRequest.getter(GetSpritesRequest::fileName)).setter(GetSpritesRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()}).build();
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(GetSpritesRequest.getter(GetSpritesRequest::styleAsString)).setter(GetSpritesRequest.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Style").build()}).build();
    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorScheme").getter(GetSpritesRequest.getter(GetSpritesRequest::colorSchemeAsString)).setter(GetSpritesRequest.setter(Builder::colorScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ColorScheme").build()}).build();
    private static final SdkField<String> VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Variant").getter(GetSpritesRequest.getter(GetSpritesRequest::variantAsString)).setter(GetSpritesRequest.setter(Builder::variant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Variant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, STYLE_FIELD, COLOR_SCHEME_FIELD, VARIANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSpritesRequest.memberNameToFieldInitializer();
    private final String fileName;
    private final String style;
    private final String colorScheme;
    private final String variant;

    private GetSpritesRequest(BuilderImpl builder) {
        super(builder);
        this.fileName = builder.fileName;
        this.style = builder.style;
        this.colorScheme = builder.colorScheme;
        this.variant = builder.variant;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final MapStyle style() {
        return MapStyle.fromValue(this.style);
    }

    public final String styleAsString() {
        return this.style;
    }

    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(this.colorScheme);
    }

    public final String colorSchemeAsString() {
        return this.colorScheme;
    }

    public final Variant variant() {
        return Variant.fromValue(this.variant);
    }

    public final String variantAsString() {
        return this.variant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpritesRequest)) {
            return false;
        }
        GetSpritesRequest other = (GetSpritesRequest)((Object)obj);
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.styleAsString(), other.styleAsString()) && Objects.equals(this.colorSchemeAsString(), other.colorSchemeAsString()) && Objects.equals(this.variantAsString(), other.variantAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSpritesRequest").add("FileName", (Object)this.fileName()).add("Style", (Object)this.styleAsString()).add("ColorScheme", (Object)this.colorSchemeAsString()).add("Variant", (Object)this.variantAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.styleAsString()));
            }
            case "ColorScheme": {
                return Optional.ofNullable(clazz.cast(this.colorSchemeAsString()));
            }
            case "Variant": {
                return Optional.ofNullable(clazz.cast(this.variantAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FileName", FILE_NAME_FIELD);
        map.put("Style", STYLE_FIELD);
        map.put("ColorScheme", COLOR_SCHEME_FIELD);
        map.put("Variant", VARIANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSpritesRequest, T> g) {
        return obj -> g.apply((GetSpritesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsRequest.BuilderImpl
    implements Builder {
        private String fileName;
        private String style;
        private String colorScheme;
        private String variant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpritesRequest model) {
            super(model);
            this.fileName(model.fileName);
            this.style(model.style);
            this.colorScheme(model.colorScheme);
            this.variant(model.variant);
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(MapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final String getColorScheme() {
            return this.colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getVariant() {
            return this.variant;
        }

        public final void setVariant(String variant) {
            this.variant = variant;
        }

        @Override
        public final Builder variant(String variant) {
            this.variant = variant;
            return this;
        }

        @Override
        public final Builder variant(Variant variant) {
            this.variant(variant == null ? null : variant.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSpritesRequest build() {
            return new GetSpritesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoMapsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSpritesRequest> {
        public Builder fileName(String var1);

        public Builder style(String var1);

        public Builder style(MapStyle var1);

        public Builder colorScheme(String var1);

        public Builder colorScheme(ColorScheme var1);

        public Builder variant(String var1);

        public Builder variant(Variant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

