/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geomaps.model.GeoMapsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTileRequest
extends GeoMapsRequest
implements ToCopyableBuilder<Builder, GetTileRequest> {
    private static final SdkField<String> TILESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tileset").getter(GetTileRequest.getter(GetTileRequest::tileset)).setter(GetTileRequest.setter(Builder::tileset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Tileset").build()}).build();
    private static final SdkField<String> Z_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Z").getter(GetTileRequest.getter(GetTileRequest::z)).setter(GetTileRequest.setter(Builder::z)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Z").build()}).build();
    private static final SdkField<String> X_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("X").getter(GetTileRequest.getter(GetTileRequest::x)).setter(GetTileRequest.setter(Builder::x)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("X").build()}).build();
    private static final SdkField<String> Y_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Y").getter(GetTileRequest.getter(GetTileRequest::y)).setter(GetTileRequest.setter(Builder::y)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Y").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetTileRequest.getter(GetTileRequest::key)).setter(GetTileRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TILESET_FIELD, Z_FIELD, X_FIELD, Y_FIELD, KEY_FIELD));
    private final String tileset;
    private final String z;
    private final String x;
    private final String y;
    private final String key;

    private GetTileRequest(BuilderImpl builder) {
        super(builder);
        this.tileset = builder.tileset;
        this.z = builder.z;
        this.x = builder.x;
        this.y = builder.y;
        this.key = builder.key;
    }

    public final String tileset() {
        return this.tileset;
    }

    public final String z() {
        return this.z;
    }

    public final String x() {
        return this.x;
    }

    public final String y() {
        return this.y;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tileset());
        hashCode = 31 * hashCode + Objects.hashCode(this.z());
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTileRequest)) {
            return false;
        }
        GetTileRequest other = (GetTileRequest)((Object)obj);
        return Objects.equals(this.tileset(), other.tileset()) && Objects.equals(this.z(), other.z()) && Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetTileRequest").add("Tileset", (Object)this.tileset()).add("Z", (Object)this.z()).add("X", (Object)this.x()).add("Y", (Object)this.y()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tileset": {
                return Optional.ofNullable(clazz.cast(this.tileset()));
            }
            case "Z": {
                return Optional.ofNullable(clazz.cast(this.z()));
            }
            case "X": {
                return Optional.ofNullable(clazz.cast(this.x()));
            }
            case "Y": {
                return Optional.ofNullable(clazz.cast(this.y()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTileRequest, T> g) {
        return obj -> g.apply((GetTileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsRequest.BuilderImpl
    implements Builder {
        private String tileset;
        private String z;
        private String x;
        private String y;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTileRequest model) {
            super(model);
            this.tileset(model.tileset);
            this.z(model.z);
            this.x(model.x);
            this.y(model.y);
            this.key(model.key);
        }

        public final String getTileset() {
            return this.tileset;
        }

        public final void setTileset(String tileset) {
            this.tileset = tileset;
        }

        @Override
        public final Builder tileset(String tileset) {
            this.tileset = tileset;
            return this;
        }

        public final String getZ() {
            return this.z;
        }

        public final void setZ(String z) {
            this.z = z;
        }

        @Override
        public final Builder z(String z) {
            this.z = z;
            return this;
        }

        public final String getX() {
            return this.x;
        }

        public final void setX(String x) {
            this.x = x;
        }

        @Override
        public final Builder x(String x) {
            this.x = x;
            return this;
        }

        public final String getY() {
            return this.y;
        }

        public final void setY(String y) {
            this.y = y;
        }

        @Override
        public final Builder y(String y) {
            this.y = y;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTileRequest build() {
            return new GetTileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GeoMapsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTileRequest> {
        public Builder tileset(String var1);

        public Builder z(String var1);

        public Builder x(String var1);

        public Builder y(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

