/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.GameSparksResponse;
import software.amazon.awssdk.services.gamesparks.model.SnapshotSummary;
import software.amazon.awssdk.services.gamesparks.model.SnapshotSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSnapshotsResponse
extends GameSparksResponse
implements ToCopyableBuilder<Builder, ListSnapshotsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSnapshotsResponse.getter(ListSnapshotsResponse::nextToken)).setter(ListSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SnapshotSummary>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Snapshots").getter(ListSnapshotsResponse.getter(ListSnapshotsResponse::snapshots)).setter(ListSnapshotsResponse.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SNAPSHOTS_FIELD));
    private final String nextToken;
    private final List<SnapshotSummary> snapshots;

    private ListSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.snapshots = builder.snapshots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<SnapshotSummary> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotsResponse)) {
            return false;
        }
        ListSnapshotsResponse other = (ListSnapshotsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots());
    }

    public final String toString() {
        return ToString.builder((String)"ListSnapshotsResponse").add("NextToken", (Object)this.nextToken()).add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotsResponse, T> g) {
        return obj -> g.apply((ListSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SnapshotSummary> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.snapshots(model.snapshots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SnapshotSummary.Builder> getSnapshots() {
            List<SnapshotSummary.Builder> result = SnapshotSummaryListCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<SnapshotSummary.BuilderImpl> snapshots) {
            this.snapshots = SnapshotSummaryListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<SnapshotSummary> snapshots) {
            this.snapshots = SnapshotSummaryListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(SnapshotSummary ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<SnapshotSummary.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (SnapshotSummary)((SnapshotSummary.Builder)SnapshotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSnapshotsResponse build() {
            return new ListSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSnapshotsResponse> {
        public Builder nextToken(String var1);

        public Builder snapshots(Collection<SnapshotSummary> var1);

        public Builder snapshots(SnapshotSummary ... var1);

        public Builder snapshots(Consumer<SnapshotSummary.Builder> ... var1);
    }
}

