/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamesparks.model.GameSparksResponse;
import software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails;
import software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeneratedCodeJobsResponse
extends GameSparksResponse
implements ToCopyableBuilder<Builder, ListGeneratedCodeJobsResponse> {
    private static final SdkField<List<GeneratedCodeJobDetails>> GENERATED_CODE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GeneratedCodeJobs").getter(ListGeneratedCodeJobsResponse.getter(ListGeneratedCodeJobsResponse::generatedCodeJobs)).setter(ListGeneratedCodeJobsResponse.setter(Builder::generatedCodeJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeneratedCodeJobDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGeneratedCodeJobsResponse.getter(ListGeneratedCodeJobsResponse::nextToken)).setter(ListGeneratedCodeJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_CODE_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GeneratedCodeJobDetails> generatedCodeJobs;
    private final String nextToken;

    private ListGeneratedCodeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.generatedCodeJobs = builder.generatedCodeJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGeneratedCodeJobs() {
        return this.generatedCodeJobs != null && !(this.generatedCodeJobs instanceof SdkAutoConstructList);
    }

    public final List<GeneratedCodeJobDetails> generatedCodeJobs() {
        return this.generatedCodeJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedCodeJobs() ? this.generatedCodeJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeneratedCodeJobsResponse)) {
            return false;
        }
        ListGeneratedCodeJobsResponse other = (ListGeneratedCodeJobsResponse)((Object)obj);
        return this.hasGeneratedCodeJobs() == other.hasGeneratedCodeJobs() && Objects.equals(this.generatedCodeJobs(), other.generatedCodeJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeneratedCodeJobsResponse").add("GeneratedCodeJobs", this.hasGeneratedCodeJobs() ? this.generatedCodeJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeneratedCodeJobs": {
                return Optional.ofNullable(clazz.cast(this.generatedCodeJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeneratedCodeJobsResponse, T> g) {
        return obj -> g.apply((ListGeneratedCodeJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameSparksResponse.BuilderImpl
    implements Builder {
        private List<GeneratedCodeJobDetails> generatedCodeJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeneratedCodeJobsResponse model) {
            super(model);
            this.generatedCodeJobs(model.generatedCodeJobs);
            this.nextToken(model.nextToken);
        }

        public final List<GeneratedCodeJobDetails.Builder> getGeneratedCodeJobs() {
            List<GeneratedCodeJobDetails.Builder> result = GeneratedCodeJobDetailsListCopier.copyToBuilder(this.generatedCodeJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedCodeJobs(Collection<GeneratedCodeJobDetails.BuilderImpl> generatedCodeJobs) {
            this.generatedCodeJobs = GeneratedCodeJobDetailsListCopier.copyFromBuilder(generatedCodeJobs);
        }

        @Override
        public final Builder generatedCodeJobs(Collection<GeneratedCodeJobDetails> generatedCodeJobs) {
            this.generatedCodeJobs = GeneratedCodeJobDetailsListCopier.copy(generatedCodeJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCodeJobs(GeneratedCodeJobDetails ... generatedCodeJobs) {
            this.generatedCodeJobs(Arrays.asList(generatedCodeJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCodeJobs(Consumer<GeneratedCodeJobDetails.Builder> ... generatedCodeJobs) {
            this.generatedCodeJobs(Stream.of(generatedCodeJobs).map(c -> (GeneratedCodeJobDetails)((GeneratedCodeJobDetails.Builder)GeneratedCodeJobDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGeneratedCodeJobsResponse build() {
            return new ListGeneratedCodeJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameSparksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGeneratedCodeJobsResponse> {
        public Builder generatedCodeJobs(Collection<GeneratedCodeJobDetails> var1);

        public Builder generatedCodeJobs(GeneratedCodeJobDetails ... var1);

        public Builder generatedCodeJobs(Consumer<GeneratedCodeJobDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

