/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse;

public class ListExtensionVersionsIterable
implements SdkIterable<ListExtensionVersionsResponse> {
    private final GameSparksClient client;
    private final ListExtensionVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExtensionVersionsIterable(GameSparksClient client, ListExtensionVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExtensionVersionsResponseFetcher();
    }

    public Iterator<ListExtensionVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExtensionVersionDetails> extensionVersions() {
        Function<ListExtensionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.extensionVersions() != null) {
                return response.extensionVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExtensionVersionsResponseFetcher
    implements SyncPageFetcher<ListExtensionVersionsResponse> {
        private ListExtensionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExtensionVersionsResponse nextPage(ListExtensionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionVersionsIterable.this.client.listExtensionVersions(ListExtensionVersionsIterable.this.firstRequest);
            }
            return ListExtensionVersionsIterable.this.client.listExtensionVersions((ListExtensionVersionsRequest)((Object)ListExtensionVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

