/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamGroupStatus {
    ACTIVATING("ACTIVATING"),
    UPDATING_LOCATIONS("UPDATING_LOCATIONS"),
    ACTIVE("ACTIVE"),
    ACTIVE_WITH_ERRORS("ACTIVE_WITH_ERRORS"),
    ERROR("ERROR"),
    DELETING("DELETING"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamGroupStatus> VALUE_MAP;
    private final String value;

    private StreamGroupStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamGroupStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamGroupStatus> knownValues() {
        EnumSet<StreamGroupStatus> knownValues = EnumSet.allOf(StreamGroupStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamGroupStatus.class, StreamGroupStatus::toString);
    }
}

