/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gameliftstreams.model.ApplicationStatus;
import software.amazon.awssdk.services.gameliftstreams.model.ApplicationStatusReason;
import software.amazon.awssdk.services.gameliftstreams.model.ArnListCopier;
import software.amazon.awssdk.services.gameliftstreams.model.FilePathsCopier;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatus;
import software.amazon.awssdk.services.gameliftstreams.model.ReplicationStatusesCopier;
import software.amazon.awssdk.services.gameliftstreams.model.RuntimeEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationResponse
extends GameLiftStreamsResponse
implements ToCopyableBuilder<Builder, GetApplicationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetApplicationResponse.getter(GetApplicationResponse::arn)).setter(GetApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetApplicationResponse.getter(GetApplicationResponse::description)).setter(GetApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<RuntimeEnvironment> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeEnvironment").getter(GetApplicationResponse.getter(GetApplicationResponse::runtimeEnvironment)).setter(GetApplicationResponse.setter(Builder::runtimeEnvironment)).constructor(RuntimeEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutablePath").getter(GetApplicationResponse.getter(GetApplicationResponse::executablePath)).setter(GetApplicationResponse.setter(Builder::executablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutablePath").build()}).build();
    private static final SdkField<List<String>> APPLICATION_LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationLogPaths").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationLogPaths)).setter(GetApplicationResponse.setter(Builder::applicationLogPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_LOG_OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationLogOutputUri").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationLogOutputUri)).setter(GetApplicationResponse.setter(Builder::applicationLogOutputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationLogOutputUri").build()}).build();
    private static final SdkField<String> APPLICATION_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationSourceUri").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationSourceUri)).setter(GetApplicationResponse.setter(Builder::applicationSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSourceUri").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetApplicationResponse.getter(GetApplicationResponse::id)).setter(GetApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetApplicationResponse.getter(GetApplicationResponse::statusAsString)).setter(GetApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetApplicationResponse.getter(GetApplicationResponse::statusReasonAsString)).setter(GetApplicationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<List<ReplicationStatus>> REPLICATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationStatuses").getter(GetApplicationResponse.getter(GetApplicationResponse::replicationStatuses)).setter(GetApplicationResponse.setter(Builder::replicationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetApplicationResponse.getter(GetApplicationResponse::createdAt)).setter(GetApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetApplicationResponse.getter(GetApplicationResponse::lastUpdatedAt)).setter(GetApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_STREAM_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedStreamGroups").getter(GetApplicationResponse.getter(GetApplicationResponse::associatedStreamGroups)).setter(GetApplicationResponse.setter(Builder::associatedStreamGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedStreamGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, RUNTIME_ENVIRONMENT_FIELD, EXECUTABLE_PATH_FIELD, APPLICATION_LOG_PATHS_FIELD, APPLICATION_LOG_OUTPUT_URI_FIELD, APPLICATION_SOURCE_URI_FIELD, ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, REPLICATION_STATUSES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ASSOCIATED_STREAM_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String description;
    private final RuntimeEnvironment runtimeEnvironment;
    private final String executablePath;
    private final List<String> applicationLogPaths;
    private final String applicationLogOutputUri;
    private final String applicationSourceUri;
    private final String id;
    private final String status;
    private final String statusReason;
    private final List<ReplicationStatus> replicationStatuses;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final List<String> associatedStreamGroups;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.executablePath = builder.executablePath;
        this.applicationLogPaths = builder.applicationLogPaths;
        this.applicationLogOutputUri = builder.applicationLogOutputUri;
        this.applicationSourceUri = builder.applicationSourceUri;
        this.id = builder.id;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.replicationStatuses = builder.replicationStatuses;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.associatedStreamGroups = builder.associatedStreamGroups;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public final String executablePath() {
        return this.executablePath;
    }

    public final boolean hasApplicationLogPaths() {
        return this.applicationLogPaths != null && !(this.applicationLogPaths instanceof SdkAutoConstructList);
    }

    public final List<String> applicationLogPaths() {
        return this.applicationLogPaths;
    }

    public final String applicationLogOutputUri() {
        return this.applicationLogOutputUri;
    }

    public final String applicationSourceUri() {
        return this.applicationSourceUri;
    }

    public final String id() {
        return this.id;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApplicationStatusReason statusReason() {
        return ApplicationStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final boolean hasReplicationStatuses() {
        return this.replicationStatuses != null && !(this.replicationStatuses instanceof SdkAutoConstructList);
    }

    public final List<ReplicationStatus> replicationStatuses() {
        return this.replicationStatuses;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasAssociatedStreamGroups() {
        return this.associatedStreamGroups != null && !(this.associatedStreamGroups instanceof SdkAutoConstructList);
    }

    public final List<String> associatedStreamGroups() {
        return this.associatedStreamGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationLogPaths() ? this.applicationLogPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLogOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationStatuses() ? this.replicationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedStreamGroups() ? this.associatedStreamGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.runtimeEnvironment(), other.runtimeEnvironment()) && Objects.equals(this.executablePath(), other.executablePath()) && this.hasApplicationLogPaths() == other.hasApplicationLogPaths() && Objects.equals(this.applicationLogPaths(), other.applicationLogPaths()) && Objects.equals(this.applicationLogOutputUri(), other.applicationLogOutputUri()) && Objects.equals(this.applicationSourceUri(), other.applicationSourceUri()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && this.hasReplicationStatuses() == other.hasReplicationStatuses() && Objects.equals(this.replicationStatuses(), other.replicationStatuses()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasAssociatedStreamGroups() == other.hasAssociatedStreamGroups() && Objects.equals(this.associatedStreamGroups(), other.associatedStreamGroups());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationResponse").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("RuntimeEnvironment", (Object)this.runtimeEnvironment()).add("ExecutablePath", (Object)this.executablePath()).add("ApplicationLogPaths", this.hasApplicationLogPaths() ? this.applicationLogPaths() : null).add("ApplicationLogOutputUri", (Object)this.applicationLogOutputUri()).add("ApplicationSourceUri", (Object)this.applicationSourceUri()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("ReplicationStatuses", this.hasReplicationStatuses() ? this.replicationStatuses() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("AssociatedStreamGroups", this.hasAssociatedStreamGroups() ? this.associatedStreamGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironment()));
            }
            case "ExecutablePath": {
                return Optional.ofNullable(clazz.cast(this.executablePath()));
            }
            case "ApplicationLogPaths": {
                return Optional.ofNullable(clazz.cast(this.applicationLogPaths()));
            }
            case "ApplicationLogOutputUri": {
                return Optional.ofNullable(clazz.cast(this.applicationLogOutputUri()));
            }
            case "ApplicationSourceUri": {
                return Optional.ofNullable(clazz.cast(this.applicationSourceUri()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "ReplicationStatuses": {
                return Optional.ofNullable(clazz.cast(this.replicationStatuses()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "AssociatedStreamGroups": {
                return Optional.ofNullable(clazz.cast(this.associatedStreamGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("ExecutablePath", EXECUTABLE_PATH_FIELD);
        map.put("ApplicationLogPaths", APPLICATION_LOG_PATHS_FIELD);
        map.put("ApplicationLogOutputUri", APPLICATION_LOG_OUTPUT_URI_FIELD);
        map.put("ApplicationSourceUri", APPLICATION_SOURCE_URI_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("ReplicationStatuses", REPLICATION_STATUSES_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("AssociatedStreamGroups", ASSOCIATED_STREAM_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private RuntimeEnvironment runtimeEnvironment;
        private String executablePath;
        private List<String> applicationLogPaths = DefaultSdkAutoConstructList.getInstance();
        private String applicationLogOutputUri;
        private String applicationSourceUri;
        private String id;
        private String status;
        private String statusReason;
        private List<ReplicationStatus> replicationStatuses = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private List<String> associatedStreamGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            this.arn(model.arn);
            this.description(model.description);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.executablePath(model.executablePath);
            this.applicationLogPaths(model.applicationLogPaths);
            this.applicationLogOutputUri(model.applicationLogOutputUri);
            this.applicationSourceUri(model.applicationSourceUri);
            this.id(model.id);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.replicationStatuses(model.replicationStatuses);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.associatedStreamGroups(model.associatedStreamGroups);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuntimeEnvironment.Builder getRuntimeEnvironment() {
            return this.runtimeEnvironment != null ? this.runtimeEnvironment.toBuilder() : null;
        }

        public final void setRuntimeEnvironment(RuntimeEnvironment.BuilderImpl runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment != null ? runtimeEnvironment.build() : null;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        public final String getExecutablePath() {
            return this.executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final Collection<String> getApplicationLogPaths() {
            if (this.applicationLogPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationLogPaths;
        }

        public final void setApplicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
        }

        @Override
        public final Builder applicationLogPaths(Collection<String> applicationLogPaths) {
            this.applicationLogPaths = FilePathsCopier.copy(applicationLogPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationLogPaths(String ... applicationLogPaths) {
            this.applicationLogPaths(Arrays.asList(applicationLogPaths));
            return this;
        }

        public final String getApplicationLogOutputUri() {
            return this.applicationLogOutputUri;
        }

        public final void setApplicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
        }

        @Override
        public final Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        public final String getApplicationSourceUri() {
            return this.applicationSourceUri;
        }

        public final void setApplicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
        }

        @Override
        public final Builder applicationSourceUri(String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ApplicationStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final List<ReplicationStatus.Builder> getReplicationStatuses() {
            List<ReplicationStatus.Builder> result = ReplicationStatusesCopier.copyToBuilder(this.replicationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatuses(Collection<ReplicationStatus.BuilderImpl> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copyFromBuilder(replicationStatuses);
        }

        @Override
        public final Builder replicationStatuses(Collection<ReplicationStatus> replicationStatuses) {
            this.replicationStatuses = ReplicationStatusesCopier.copy(replicationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(ReplicationStatus ... replicationStatuses) {
            this.replicationStatuses(Arrays.asList(replicationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(Consumer<ReplicationStatus.Builder> ... replicationStatuses) {
            this.replicationStatuses(Stream.of(replicationStatuses).map(c -> (ReplicationStatus)((ReplicationStatus.Builder)ReplicationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Collection<String> getAssociatedStreamGroups() {
            if (this.associatedStreamGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedStreamGroups;
        }

        public final void setAssociatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
        }

        @Override
        public final Builder associatedStreamGroups(Collection<String> associatedStreamGroups) {
            this.associatedStreamGroups = ArnListCopier.copy(associatedStreamGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedStreamGroups(String ... associatedStreamGroups) {
            this.associatedStreamGroups(Arrays.asList(associatedStreamGroups));
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationResponse> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        default public Builder runtimeEnvironment(Consumer<RuntimeEnvironment.Builder> runtimeEnvironment) {
            return this.runtimeEnvironment((RuntimeEnvironment)((RuntimeEnvironment.Builder)RuntimeEnvironment.builder().applyMutation(runtimeEnvironment)).build());
        }

        public Builder executablePath(String var1);

        public Builder applicationLogPaths(Collection<String> var1);

        public Builder applicationLogPaths(String ... var1);

        public Builder applicationLogOutputUri(String var1);

        public Builder applicationSourceUri(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ApplicationStatusReason var1);

        public Builder replicationStatuses(Collection<ReplicationStatus> var1);

        public Builder replicationStatuses(ReplicationStatus ... var1);

        public Builder replicationStatuses(Consumer<ReplicationStatus.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder associatedStreamGroups(Collection<String> var1);

        public Builder associatedStreamGroups(String ... var1);
    }
}

